/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.DelegatingRepository;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.config.DelegatingRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;
import org.eclipse.rdf4j.repository.event.NotifyingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.base.RepositoryConnectionListenerAdapter;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.manager.SystemRepository;
import org.eclipse.rdf4j.repository.manager.SystemRepositoryConfig;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

public class LocalRepositoryManager
extends RepositoryManager {
    public static final String REPOSITORIES_DIR = "repositories";
    private static final RDFFormat CONFIG_FORMAT = RDFFormat.TURTLE;
    private static final String CFG_FILE = "config." + CONFIG_FORMAT.getDefaultFileExtension();
    private static final WriterConfig CFG_CONFIG = ((WriterConfig)((WriterConfig)new WriterConfig().set((RioSetting)BasicWriterSettings.BASE_DIRECTIVE, (Object)false)).set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true)).set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
    private final File baseDir;
    private volatile SharedHttpClientSessionManager client;
    private volatile SPARQLServiceResolver serviceResolver;
    private boolean upgraded;

    public LocalRepositoryManager(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    @Deprecated
    protected SystemRepository createSystemRepository() throws RepositoryException {
        File systemDir = this.getRepositoryDir("SYSTEM");
        SystemRepository systemRepos = new SystemRepository(systemDir);
        systemRepos.init();
        systemRepos.addRepositoryConnectionListener(new ConfigChangeListener());
        return systemRepos;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return this.baseDir.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedHttpClientSessionManager getSesameClient() {
        SharedHttpClientSessionManager result = this.client;
        if (result == null) {
            LocalRepositoryManager localRepositoryManager = this;
            synchronized (localRepositoryManager) {
                result = this.client;
                if (result == null) {
                    result = this.client = new SharedHttpClientSessionManager();
                }
            }
        }
        return result;
    }

    @Override
    public HttpClient getHttpClient() {
        SharedHttpClientSessionManager nextClient = this.client;
        if (nextClient == null) {
            return null;
        }
        return nextClient.getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        this.getSesameClient().setHttpClient(httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FederatedServiceResolver getFederatedServiceResolver() {
        SPARQLServiceResolver result = this.serviceResolver;
        if (result == null) {
            LocalRepositoryManager localRepositoryManager = this;
            synchronized (localRepositoryManager) {
                result = this.serviceResolver;
                if (result == null) {
                    result = this.serviceResolver = new SPARQLServiceResolver();
                    result.setHttpClientSessionManager(this.getSesameClient());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            super.shutDown();
        }
        finally {
            try {
                SPARQLServiceResolver toCloseServiceResolver = this.serviceResolver;
                this.serviceResolver = null;
                if (toCloseServiceResolver != null) {
                    toCloseServiceResolver.shutDown();
                }
            }
            finally {
                SharedHttpClientSessionManager toCloseClient = this.client;
                this.client = null;
                if (toCloseClient != null) {
                    toCloseClient.shutDown();
                }
            }
        }
    }

    public File resolvePath(String path) {
        return new File(this.getBaseDir(), path);
    }

    public File getRepositoryDir(String repositoryID) {
        File repositoriesDir = this.resolvePath(REPOSITORIES_DIR);
        return new File(repositoriesDir, repositoryID);
    }

    @Override
    @Deprecated
    public SystemRepository getSystemRepository() {
        if (this.getRepositoryDir("SYSTEM").isDirectory()) {
            return (SystemRepository)super.getSystemRepository();
        }
        return null;
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        Repository repository = null;
        RepositoryConfig repConfig = this.getRepositoryConfig(id);
        if (repConfig != null) {
            repConfig.validate();
            repository = this.createRepositoryStack(repConfig.getRepositoryImplConfig());
            repository.setDataDir(this.getRepositoryDir(id));
            repository.init();
        }
        return repository;
    }

    private Repository createRepositoryStack(RepositoryImplConfig config) throws RepositoryConfigException {
        RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(config.getType()).orElseThrow(() -> new RepositoryConfigException("Unsupported repository type: " + config.getType()));
        Repository repository = factory.getRepository(config);
        if (repository instanceof RepositoryResolverClient) {
            ((RepositoryResolverClient)((Object)repository)).setRepositoryResolver(this);
        }
        if (repository instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)((Object)repository)).setFederatedServiceResolver(this.getFederatedServiceResolver());
        }
        if (repository instanceof SessionManagerDependent) {
            ((SessionManagerDependent)((Object)repository)).setHttpClientSessionManager(this.client);
        } else if (repository instanceof HttpClientDependent) {
            ((HttpClientDependent)((Object)repository)).setHttpClient(this.getHttpClient());
        }
        if (config instanceof DelegatingRepositoryImplConfig) {
            RepositoryImplConfig delegateConfig = ((DelegatingRepositoryImplConfig)config).getDelegate();
            Repository delegate = this.createRepositoryStack(delegateConfig);
            try {
                ((DelegatingRepository)repository).setDelegate(delegate);
            }
            catch (ClassCastException e) {
                throw new RepositoryConfigException("Delegate specified for repository that is not a DelegatingRepository: " + delegate.getClass(), e);
            }
        }
        return repository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RepositoryConfig getRepositoryConfig(String id) {
        File dataDir = this.getRepositoryDir(id);
        if (!new File(dataDir, CFG_FILE).exists()) {
            if (!id.equals("SYSTEM")) return super.getRepositoryConfig(id);
            return new RepositoryConfig(id, new SystemRepositoryConfig());
        }
        File configFile = new File(dataDir, CFG_FILE);
        try (FileInputStream input = new FileInputStream(configFile);){
            Model model = Rio.parse((InputStream)input, configFile.toURI().toString(), CONFIG_FORMAT, new Resource[0]);
            Set<String> repositoryIDs = RepositoryConfigUtil.getRepositoryIDs(model);
            if (repositoryIDs.isEmpty()) {
                throw new RepositoryConfigException("No repository ID in configuration: " + configFile);
            }
            if (repositoryIDs.size() != 1) {
                throw new RepositoryConfigException("Multiple repository IDs in configuration: " + configFile);
            }
            String repositoryID = repositoryIDs.iterator().next();
            if (!id.equals(repositoryID) && !this.getRepositoryDir(repositoryID).getCanonicalFile().equals(dataDir.getCanonicalFile())) {
                throw new RepositoryConfigException("Wrong repository ID in configuration: " + configFile);
            }
            RepositoryConfig repositoryConfig = RepositoryConfigUtil.getRepositoryConfig(model, repositoryID);
            return repositoryConfig;
        }
        catch (IOException e) {
            throw new RepositoryConfigException(e);
        }
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) {
        RepositoryConfig config = this.getRepositoryConfig(id);
        if (config == null) {
            return null;
        }
        RepositoryInfo repInfo = new RepositoryInfo();
        repInfo.setId(config.getID());
        repInfo.setDescription(config.getTitle());
        try {
            repInfo.setLocation(this.getRepositoryDir(config.getID()).toURI().toURL());
        }
        catch (MalformedURLException mue) {
            throw new RepositoryException("Location of repository does not resolve to a valid URL", mue);
        }
        repInfo.setReadable(true);
        repInfo.setWritable(true);
        return repInfo;
    }

    public synchronized List<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        SystemRepository systemRepository;
        File repositoriesDir = this.resolvePath(REPOSITORIES_DIR);
        String[] dirs = repositoriesDir.list((repositories, name) -> {
            File dataDir = new File(repositories, name);
            return dataDir.isDirectory() && new File(dataDir, CFG_FILE).exists();
        });
        if ((dirs == null || dirs.length == 0) && (systemRepository = this.getSystemRepository()) != null) {
            dirs = RepositoryConfigUtil.getRepositoryIDs(systemRepository).toArray(new String[0]);
        }
        if (dirs == null) {
            return Collections.emptyList();
        }
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (String name2 : dirs) {
            RepositoryInfo repInfo = this.getRepositoryInfo(name2);
            if (skipSystemRepo && repInfo.getId().equals("SYSTEM")) continue;
            result.add(repInfo);
        }
        return result;
    }

    @Override
    public synchronized void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        this.addRepositoryConfig(config, true);
    }

    private synchronized void addRepositoryConfig(RepositoryConfig config, boolean updateSystem) {
        File dataDir = this.getRepositoryDir(config.getID());
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        if (!dataDir.isDirectory()) {
            throw new RepositoryConfigException("Could not create directory: " + dataDir);
        }
        File configFile = new File(dataDir, CFG_FILE);
        if (!this.upgraded && !configFile.exists()) {
            this.upgraded = true;
            this.upgrade();
        }
        Model model = this.getModelFactory().createEmptyModel();
        String ns = configFile.toURI().toString() + "#";
        config.export(model, SimpleValueFactory.getInstance().createIRI(ns, config.getID()));
        File part = new File(configFile.getParentFile(), configFile.getName() + ".part");
        try (FileOutputStream output = new FileOutputStream(part);){
            Rio.write((Iterable<Statement>)model, output, configFile.toURI().toString(), CONFIG_FORMAT, CFG_CONFIG);
        }
        catch (IOException | URISyntaxException | RDFHandlerException | UnsupportedRDFormatException e) {
            throw new RepositoryConfigException(e);
        }
        try {
            Files.move(part.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RepositoryConfigException(e);
        }
        if (updateSystem) {
            super.addRepositoryConfig(config);
        }
    }

    @Override
    public synchronized boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        return this.removeRepository(repositoryID, true);
    }

    private boolean removeRepository(String repositoryID, boolean updateSystem) {
        boolean removed = updateSystem ? super.removeRepository(repositoryID) : false;
        File dataDir = this.getRepositoryDir(repositoryID);
        if (dataDir.isDirectory()) {
            this.logger.debug("Cleaning up data dir {} for repository {}", (Object)dataDir.getAbsolutePath(), (Object)repositoryID);
            try {
                FileUtil.deleteDir(dataDir);
            }
            catch (IOException e) {
                throw new RepositoryConfigException(e);
            }
            return true;
        }
        return removed;
    }

    private synchronized void upgrade() {
        File repositoriesDir = this.resolvePath(REPOSITORIES_DIR);
        String[] dirs = repositoriesDir.list((repositories, name) -> {
            File dataDir = new File(repositories, name);
            return dataDir.isDirectory() && new File(dataDir, CFG_FILE).exists();
        });
        if (dirs != null && dirs.length > 0) {
            return;
        }
        SystemRepository systemRepository = this.getSystemRepository();
        if (systemRepository == null) {
            return;
        }
        Set<String> ids = RepositoryConfigUtil.getRepositoryIDs(systemRepository);
        ArrayList<RepositoryConfig> configs = new ArrayList<RepositoryConfig>();
        for (String id : ids) {
            configs.add(this.getRepositoryConfig(id));
        }
        for (RepositoryConfig config : configs) {
            this.addRepositoryConfig(config);
        }
    }

    class ConfigChangeListener
    extends RepositoryConnectionListenerAdapter {
        private final Map<RepositoryConnection, Set<Resource>> modifiedContextsByConnection = new HashMap<RepositoryConnection, Set<Resource>>();
        private final Map<RepositoryConnection, Boolean> modifiedAllContextsByConnection = new HashMap<RepositoryConnection, Boolean>();
        private final Map<RepositoryConnection, Set<Resource>> removedContextsByConnection = new HashMap<RepositoryConnection, Set<Resource>>();

        ConfigChangeListener() {
        }

        private Set<Resource> getModifiedContexts(RepositoryConnection conn) {
            Set<Resource> result = this.modifiedContextsByConnection.get(conn);
            if (result == null) {
                result = new HashSet<Resource>();
                this.modifiedContextsByConnection.put(conn, result);
            }
            return result;
        }

        private Set<Resource> getRemovedContexts(RepositoryConnection conn) {
            Set<Resource> result = this.removedContextsByConnection.get(conn);
            if (result == null) {
                result = new HashSet<Resource>();
                this.removedContextsByConnection.put(conn, result);
            }
            return result;
        }

        private void registerModifiedContexts(RepositoryConnection conn, Resource ... contexts) {
            Set<Resource> modifiedContexts = this.getModifiedContexts(conn);
            if (contexts == null) {
                this.modifiedAllContextsByConnection.put(conn, true);
            } else {
                for (Resource context : contexts) {
                    modifiedContexts.add(context);
                }
            }
        }

        @Override
        public void add(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) {
            this.registerModifiedContexts(conn, contexts);
        }

        @Override
        public void clear(RepositoryConnection conn, Resource ... contexts) {
            this.registerModifiedContexts(conn, contexts);
        }

        @Override
        public void remove(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) {
            if (object != null && object.equals(RepositoryConfigSchema.REPOSITORY_CONTEXT)) {
                if (subject == null) {
                    this.modifiedAllContextsByConnection.put(conn, true);
                } else {
                    Set<Resource> removedContexts = this.getRemovedContexts(conn);
                    removedContexts.add(subject);
                }
            }
            this.registerModifiedContexts(conn, contexts);
        }

        @Override
        public void rollback(RepositoryConnection conn) {
            this.modifiedContextsByConnection.remove(conn);
            this.modifiedAllContextsByConnection.remove(conn);
        }

        @Override
        public void commit(RepositoryConnection con) {
            Boolean fullRefreshNeeded = this.modifiedAllContextsByConnection.remove(con);
            if (fullRefreshNeeded != null && fullRefreshNeeded.booleanValue()) {
                LocalRepositoryManager.this.logger.debug("Reacting to commit on SystemRepository for all contexts");
                LocalRepositoryManager.this.refresh();
            } else {
                Set<Resource> modifiedContexts = this.modifiedContextsByConnection.remove(con);
                Set<Resource> removedContexts = this.removedContextsByConnection.remove(con);
                if (removedContexts != null && !removedContexts.isEmpty()) {
                    modifiedContexts.removeAll(removedContexts);
                }
                if (modifiedContexts != null) {
                    LocalRepositoryManager.this.logger.debug("React to commit on SystemRepository for contexts {}", modifiedContexts);
                    try (NotifyingRepositoryConnection cleanupCon = LocalRepositoryManager.this.getSystemRepository().getConnection();){
                        for (Resource context : modifiedContexts) {
                            LocalRepositoryManager.this.logger.debug("Processing modified context {}.", (Object)context);
                            try {
                                if (this.isRepositoryConfigContext(cleanupCon, context)) {
                                    String repositoryID = this.getRepositoryID(cleanupCon, context);
                                    if ("SYSTEM".equals(repositoryID)) continue;
                                    LocalRepositoryManager.this.logger.debug("Reacting to modified repository config for {}", (Object)repositoryID);
                                    Repository repository = LocalRepositoryManager.this.removeInitializedRepository(repositoryID);
                                    if (repository != null) {
                                        LocalRepositoryManager.this.logger.debug("Modified repository {} has been initialized, refreshing...", (Object)repositoryID);
                                        LocalRepositoryManager.this.refreshRepository(repositoryID, repository);
                                        continue;
                                    }
                                    LocalRepositoryManager.this.logger.debug("Modified repository {} has not been initialized, skipping...", (Object)repositoryID);
                                    continue;
                                }
                                LocalRepositoryManager.this.logger.debug("Context {} doesn't contain repository config information.", (Object)context);
                            }
                            catch (RepositoryException re) {
                                LocalRepositoryManager.this.logger.error("Failed to process repository configuration changes", (Throwable)re);
                            }
                        }
                    }
                    catch (RepositoryException re) {
                        LocalRepositoryManager.this.logger.error("Failed to process repository configuration changes", (Throwable)re);
                    }
                }
            }
            SystemRepository systemRepository = LocalRepositoryManager.this.getSystemRepository();
            for (String repositoryID : RepositoryConfigUtil.getRepositoryIDs(systemRepository)) {
                if ("SYSTEM".equals(repositoryID)) continue;
                LocalRepositoryManager.this.addRepositoryConfig(RepositoryConfigUtil.getRepositoryConfig(con.getRepository(), repositoryID), false);
            }
            for (String repositoryID : LocalRepositoryManager.this.getRepositoryIDs()) {
                if ("SYSTEM".equals(repositoryID) || RepositoryConfigUtil.hasRepositoryConfig(systemRepository, repositoryID)) continue;
                LocalRepositoryManager.this.removeRepository(repositoryID, false);
            }
        }

        private boolean isRepositoryConfigContext(RepositoryConnection con, Resource context) throws RepositoryException {
            LocalRepositoryManager.this.logger.debug("Is {} a repository config context?", (Object)context);
            return con.hasStatement(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, true, new Resource[]{null});
        }

        private String getRepositoryID(RepositoryConnection con, Resource context) throws RepositoryException {
            String result = null;
            try (RepositoryResult<Statement> idStatements = con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, null, true, context);){
                if (idStatements.hasNext()) {
                    Statement idStatement = idStatements.next();
                    result = idStatement.getObject().stringValue();
                }
            }
            return result;
        }
    }
}

