/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleLengthFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPropertyShape
extends PathPropertyShape {
    private final Resource classResource;
    private static final Logger logger = LoggerFactory.getLogger(ClassPropertyShape.class);

    ClassPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape) {
        super(id, connection, nodeShape);
        try (Stream<Statement> stream = Iterations.stream(connection.getStatements(id, SHACL.CLASS, null, true, new Resource[0]));){
            this.classResource = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().orElseThrow(() -> new RuntimeException("Expected to find sh:class on " + id));
        }
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNode overrideTargetNode) {
        SailConnection addedStatements = shaclSailConnection.getAddedStatements();
        if (overrideTargetNode != null) {
            LoggingNode bulkedEternalLeftOuter = new LoggingNode(new BulkedExternalLeftOuterJoin(overrideTargetNode, shaclSailConnection, this.path.getQuery("?a", "?c", null), false), "");
            LoggingNode addedStatementsTypeFilter = new LoggingNode(new ExternalTypeFilterNode(addedStatements, this.classResource, bulkedEternalLeftOuter, 1, false), "");
            LoggingNode invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new LoggingNode(new ExternalTypeFilterNode(shaclSailConnection, this.classResource, addedStatementsTypeFilter, 1, false), "");
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, this);
        }
        LoggingNode addedByPath = new LoggingNode(this.getPlanAddedStatements(shaclSailConnection, nodeShape), "");
        InnerJoin innerJoinHolder = new InnerJoin(new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape), ""), addedByPath);
        LoggingNode innerJoin = new LoggingNode(innerJoinHolder.getJoined(BufferedPlanNode.class), "");
        LoggingNode discardedRight = new LoggingNode(innerJoinHolder.getDiscardedRight(BufferedPlanNode.class), "");
        LoggingNode typeFilterPlan = new LoggingNode(nodeShape.getTargetFilter(shaclSailConnection, discardedRight), "");
        innerJoin = new LoggingNode(new Unique(new UnionNode(innerJoin, typeFilterPlan)), "");
        LoggingNode bulkedExternalLeftOuter = new LoggingNode(new BulkedExternalLeftOuterJoin(new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape), ""), shaclSailConnection, this.path.getQuery("?a", "?c", null), true), "");
        PlanNode joined = new TupleLengthFilter(new UnionNode(innerJoin, bulkedExternalLeftOuter), 2, false).getTrueNode(UnBufferedPlanNode.class);
        LoggingNode addedStatementsTypeFilter = new LoggingNode(new ExternalTypeFilterNode(addedStatements, this.classResource, joined, 1, false), "");
        LoggingNode invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new LoggingNode(new ExternalTypeFilterNode(shaclSailConnection, this.classResource, addedStatementsTypeFilter, 1, false), "");
        if (shaclSailConnection.stats.hasRemoved()) {
            LoggingNode removedTypeStatements = new LoggingNode(new Select(shaclSailConnection.getRemovedStatements(), "?a a <" + this.classResource + ">"), "removedTypeStatements");
            String query = this.path.getQuery("?c", "?a", null) + nodeShape.getQuery("?c", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
            Sort invalidDataDueToRemovedTypeStatement = new Sort(new ModifyTuple(new LoggingNode(new BulkedExternalInnerJoin(removedTypeStatements, shaclSailConnection, query, false), ""), t -> {
                List<Value> line = t.line;
                t.line = new ArrayList<Value>();
                t.line.add(line.get(2));
                t.line.add(line.get(0));
                return t;
            }));
            invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new LoggingNode(new UnionNode(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, invalidDataDueToRemovedTypeStatement), "");
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, this);
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return removedStatements.hasStatement(null, RDF.TYPE, this.classResource, true, new Resource[0]) || super.requiresEvaluation(addedStatements, removedStatements);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.ClassConstraintComponent;
    }
}

