/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.MemValueFactory;

class MemEvaluationStatistics
extends EvaluationStatistics {
    private final MemValueFactory valueFactory;

    MemEvaluationStatistics(MemValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new MemCardinalityCalculator();
    }

    protected class MemCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected MemCardinalityCalculator() {
        }

        @Override
        public double getCardinality(StatementPattern sp) {
            Value pred;
            Value subj = this.getConstantValue(sp.getSubjectVar());
            if (!(subj instanceof Resource)) {
                subj = null;
            }
            if (!((pred = this.getConstantValue(sp.getPredicateVar())) instanceof IRI)) {
                pred = null;
            }
            Value obj = this.getConstantValue(sp.getObjectVar());
            Value context = this.getConstantValue(sp.getContextVar());
            if (!(context instanceof Resource)) {
                context = null;
            }
            MemResource memSubj = MemEvaluationStatistics.this.valueFactory.getMemResource((Resource)subj);
            MemIRI memPred = MemEvaluationStatistics.this.valueFactory.getMemURI((IRI)pred);
            MemValue memObj = MemEvaluationStatistics.this.valueFactory.getMemValue(obj);
            MemResource memContext = MemEvaluationStatistics.this.valueFactory.getMemResource((Resource)context);
            if (subj != null && memSubj == null || pred != null && memPred == null || obj != null && memObj == null || context != null && memContext == null) {
                return 0.0;
            }
            ArrayList<Integer> listSizes = new ArrayList<Integer>(4);
            if (memSubj != null) {
                listSizes.add(memSubj.getSubjectStatementCount());
            }
            if (memPred != null) {
                listSizes.add(memPred.getPredicateStatementCount());
            }
            if (memObj != null) {
                listSizes.add(memObj.getObjectStatementCount());
            }
            if (memContext != null) {
                listSizes.add(memContext.getContextStatementCount());
            }
            double cardinality = listSizes.isEmpty() ? 2.147483647E9 : (double)((Integer)Collections.min(listSizes)).intValue();
            return cardinality;
        }

        protected Value getConstantValue(Var var) {
            if (var != null) {
                return var.getValue();
            }
            return null;
        }
    }
}

