/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.dialogs;

import java.text.SimpleDateFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.MailInputValidator;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.SMTPHostString;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.dialogs.CalendarDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ScheduleMeetingInputDialog
extends FormDialog {
    private static final String MEETING_DIALOG_TITLE = "Meeting Information";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter Meeting Information";
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MMM-dd HH:mm";
    protected Long fStartTime = null;
    protected Button fCalendarButton = null;
    private Integer fDuration = null;
    private String fLocation = null;
    protected Text fStartTimeInputTextField = null;
    private Text fDurationInputTextField = null;
    private Text fLocationInputTextField = null;
    private final IInputValidator fValidator;

    public ScheduleMeetingInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(true);
        this.fValidator = new MailInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String validateResult = this.validateEmptyInput(this.fStartTimeInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("start_time_Error"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, validateResult, null), 4);
                dialog.open();
                this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
                return;
            }
            validateResult = this.validateEmptyInput(this.fDurationInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("duration_Error"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, validateResult, null), 4);
                dialog.open();
                this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
                return;
            }
            this.fDuration = Integer.valueOf(this.fDurationInputTextField.getText());
            validateResult = this.validateEmptyInput(this.fLocationInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("location_Error"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, validateResult, null), 4);
                dialog.open();
                this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
                return;
            }
            this.fLocation = this.fLocationInputTextField.getText();
        } else {
            this.fStartTime = null;
            this.fDuration = null;
            this.fLocation = null;
        }
        this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MEETING_DIALOG_TITLE);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText(SMTPHostString.getString("basic_parameter"));
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScheduleMeetingInputDialog.this.getShell().setSize(ScheduleMeetingInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Composite meetingComposite = toolkit.createComposite(basicSectionClient);
        GridData textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 3;
        meetingComposite.setLayoutData((Object)textGridData);
        meetingComposite.setLayout((Layout)new GridLayout(4, false));
        Label meetingStartTimeLabel = toolkit.createLabel(meetingComposite, SMTPHostString.getString("start_time_label"));
        meetingStartTimeLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fStartTimeInputTextField = toolkit.createText(meetingComposite, "", 2048);
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 2;
        this.fStartTimeInputTextField.setLayoutData((Object)textGridData);
        this.fStartTimeInputTextField.setEditable(false);
        this.fCalendarButton = toolkit.createButton(meetingComposite, "...", 0);
        this.fCalendarButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fCalendarButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CalendarDialog dialog = new CalendarDialog(ScheduleMeetingInputDialog.this.getShell(), true);
                int result = dialog.open();
                if (result == 0) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(ScheduleMeetingInputDialog.SIMPLE_DATE_FORMAT);
                    ScheduleMeetingInputDialog.this.fStartTimeInputTextField.setText(dateFormat.format(dialog.getDate()));
                    ScheduleMeetingInputDialog.this.fStartTime = dialog.getDate().getTime();
                    ScheduleMeetingInputDialog.this.getShell().setSize(ScheduleMeetingInputDialog.this.getShell().computeSize(-1, -1));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label meetingEndTimeLabel = toolkit.createLabel(meetingComposite, SMTPHostString.getString("duration_label"));
        meetingEndTimeLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fDurationInputTextField = toolkit.createText(meetingComposite, "", 2048);
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 2;
        this.fDurationInputTextField.setLayoutData((Object)textGridData);
        toolkit.createLabel(meetingComposite, "");
        Label meetingLocationLabel = toolkit.createLabel(meetingComposite, SMTPHostString.getString("location_label"));
        meetingLocationLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fLocationInputTextField = toolkit.createText(meetingComposite, "", 2048);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 2;
        this.fLocationInputTextField.setLayoutData((Object)textGridData);
        toolkit.createLabel(meetingComposite, "");
    }

    protected boolean isResizable() {
        return true;
    }

    public Long getStartTime() {
        return this.fStartTime;
    }

    public Integer getDuration() {
        return this.fDuration;
    }

    public String getLocation() {
        return this.fLocation;
    }

    private String validateEmptyInput(Text aText) {
        if (this.fValidator != null) {
            return this.fValidator.isValid(aText.getText());
        }
        return null;
    }

    public void setStartTime(Long aSt) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT);
        this.fStartTimeInputTextField.setText(dateFormat.format(aSt));
        this.fStartTime = aSt;
    }

    public void setDuration(Integer aDuration) {
        String durationStr = aDuration == null ? "" : aDuration.toString();
        this.fDurationInputTextField.setText(durationStr);
    }

    public void setLocation(String aLoc) {
        String location = aLoc;
        if (location == null) {
            location = "";
        }
        this.fLocationInputTextField.setText(location);
    }
}

