/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICalendarDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IReviewInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.EditableListWidget;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewInputDialog
extends FormDialog
implements IReviewInputDialog {
    private static final String ADD_REVIEW_DIALOG_TITLE = "Enter Review Details";
    private static final String ADD_REVIEW_TYPE_DIALOG_VALUE = "Review Type: ";
    private static final String ADD_REVIEW_NAME_DIALOG_VALUE = "Review Name: ";
    private static final String ADD_REVIEW_DESCRIPTION_DIALOG_VALUE = "Review Description: ";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this Review";
    private static final String EXTRA_PARAMS_HEADER_MSG = "Enter the optional extra parameters for this Review";
    private static final String ADD_REVIEW_PROJECT_DIALOG_VALUE = "Project:";
    private static final String ADD_REVIEW_COMPONENTS_DIALOG_VALUE = "Components:";
    private static final String ADD_REVIEW_ENTRY_CRITERIA_DIALOG_VALUE = "Entry Criteria:";
    private static final String ADD_REVIEW_OBJECTIVES_DIALOG_VALUE = "Objectives:";
    private static final String ADD_REVIEW_REFERENCE_MATERIAL_DIALOG_VALUE = "Reference Material:";
    private static final String[] REVIEW_TYPES = new String[]{"Basic", "Informal", "Formal"};
    private R4EUIReviewGroup fParentGroup = null;
    private CCombo fReviewType = null;
    private R4EReviewType fReviewTypeValue;
    private String fReviewNameValue = "";
    protected Text fReviewNameInputTextField;
    private String fReviewDescriptionValue = "";
    private Text fReviewDescriptionInputTextField = null;
    protected Text fDueDateText = null;
    private Date fDueDateValue = null;
    private String fProjectValue = "";
    private CCombo fProjectsCombo = null;
    private String[] fComponentsValues = null;
    private EditableListWidget fComponents = null;
    private String fEntryCriteriaValue = "";
    private Text fEntryCriteriaTextField = null;
    private String fObjectivesValue = "";
    private Text fObjectivesTextField = null;
    private String fReferenceMaterialValue = "";
    private Text fReferenceMaterialTextField = null;
    private final IInputValidator fValidator;

    public ReviewInputDialog(Shell aParentShell, R4EUIReviewGroup aParentGroup) {
        super(aParentShell);
        this.setBlockOnOpen(true);
        this.fValidator = new R4EInputValidator();
        this.fParentGroup = aParentGroup;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.fReviewType.getText().equals("Formal")) {
                this.fReviewTypeValue = R4EReviewType.R4E_REVIEW_TYPE_FORMAL;
            } else if (this.fReviewType.getText().equals("Informal")) {
                this.fReviewTypeValue = R4EReviewType.R4E_REVIEW_TYPE_INFORMAL;
            } else if (this.fReviewType.getText().equals("Basic")) {
                this.fReviewTypeValue = R4EReviewType.R4E_REVIEW_TYPE_BASIC;
            } else {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Review Type", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, null, null), 4);
                dialog.open();
                return;
            }
            String validateResult = this.validateEmptyInput(this.fReviewNameInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Review Name", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            validateResult = this.validateReviewExists(this.fReviewNameInputTextField, this.fParentGroup);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Review already exists", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fReviewNameValue = this.fReviewNameInputTextField.getText().trim();
            validateResult = this.validateEmptyInput(this.fReviewDescriptionInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Review Description", (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 2);
                dialog.open();
            }
            this.fReviewDescriptionValue = this.fReviewDescriptionInputTextField.getText().trim();
            validateResult = this.validateEmptyInput(this.fProjectsCombo.getText());
            if (validateResult == null) {
                this.fProjectValue = this.fProjectsCombo.getText();
            }
            ArrayList<String> componentsValues = new ArrayList<String>();
            Item[] itemArray = this.fComponents.getItems();
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                validateResult = this.validateEmptyInput(item.getText());
                if (validateResult == null) {
                    componentsValues.add(item.getText());
                }
                ++n2;
            }
            this.fComponentsValues = componentsValues.toArray(new String[componentsValues.size()]);
            validateResult = this.validateEmptyInput(this.fEntryCriteriaTextField);
            if (validateResult == null) {
                this.fEntryCriteriaValue = this.fEntryCriteriaTextField.getText().trim();
            }
            if ((validateResult = this.validateEmptyInput(this.fObjectivesTextField)) == null) {
                this.fObjectivesValue = this.fObjectivesTextField.getText().trim();
            }
            if ((validateResult = this.validateEmptyInput(this.fReferenceMaterialTextField)) == null) {
                this.fReferenceMaterialValue = this.fReferenceMaterialTextField.getText().trim();
            }
        } else {
            this.fReviewNameValue = null;
            this.fReviewDescriptionValue = null;
            this.fProjectValue = null;
            this.fEntryCriteriaValue = null;
            this.fObjectivesValue = null;
            this.fReferenceMaterialValue = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_REVIEW_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Label label = toolkit.createLabel(composite, ADD_REVIEW_TYPE_DIALOG_VALUE);
        label.setToolTipText("The type of the Review:  Basic Reviews are the Simplest and most Flexible ones.  Informal Reviews introduces State Tracking for Anomalies.  Formal Reviews are Structured Reviews that Conforms to the IEEE standard 1028");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fReviewType = new CCombo(composite, 2056);
        this.fReviewType.setItems(REVIEW_TYPES);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fReviewType.setToolTipText("The type of the Review:  Basic Reviews are the Simplest and most Flexible ones.  Informal Reviews introduces State Tracking for Anomalies.  Formal Reviews are Structured Reviews that Conforms to the IEEE standard 1028");
        this.fReviewType.setLayoutData((Object)textGridData);
        this.fReviewType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReviewInputDialog.this.fReviewType.getText().length() > 0 && ReviewInputDialog.this.fReviewNameInputTextField.getText().length() > 0 && ReviewInputDialog.this.fReviewDescriptionInputTextField.getText().length() > 0) {
                    ReviewInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReviewInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ReviewInputDialog.this.getShell().setSize(ReviewInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        label = toolkit.createLabel(basicSectionClient, ADD_REVIEW_NAME_DIALOG_VALUE);
        label.setToolTipText("A Name that Identifies this Review");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fReviewNameInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fReviewNameInputTextField.setToolTipText("A Name that Identifies this Review");
        this.fReviewNameInputTextField.setLayoutData((Object)textGridData);
        this.fReviewNameInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReviewInputDialog.this.fReviewType.getText().length() > 0 && ReviewInputDialog.this.fReviewNameInputTextField.getText().length() > 0 && ReviewInputDialog.this.fReviewDescriptionInputTextField.getText().length() > 0) {
                    ReviewInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReviewInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_REVIEW_DESCRIPTION_DIALOG_VALUE);
        label.setToolTipText("A Description of the Review");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fReviewDescriptionInputTextField = toolkit.createText(basicSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fReviewNameInputTextField.getLineHeight() * 6;
        this.fReviewDescriptionInputTextField.setToolTipText("A Description of the Review");
        this.fReviewDescriptionInputTextField.setLayoutData((Object)textGridData);
        this.fReviewDescriptionInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReviewInputDialog.this.fReviewType.getText().length() > 0 && ReviewInputDialog.this.fReviewNameInputTextField.getText().length() > 0 && ReviewInputDialog.this.fReviewDescriptionInputTextField.getText().length() > 0) {
                    ReviewInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReviewInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Section extraSection = toolkit.createSection(composite, 386);
        GridData extraSectionGridData = new GridData(4, 4, true, false);
        extraSectionGridData.horizontalSpan = 4;
        extraSection.setLayoutData((Object)extraSectionGridData);
        extraSection.setText("Extra Parameters");
        extraSection.setDescription(EXTRA_PARAMS_HEADER_MSG);
        extraSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ReviewInputDialog.this.getShell().setSize(ReviewInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite extraSectionClient = toolkit.createComposite((Composite)extraSection);
        extraSectionClient.setLayout((Layout)layout);
        extraSection.setClient((Control)extraSectionClient);
        IStructuredSelection selection = (IStructuredSelection)R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
        R4EUIReviewGroup parentGroup = (R4EUIReviewGroup)selection.getFirstElement();
        toolkit.setBorderStyle(0);
        label = toolkit.createLabel(extraSectionClient, "Due Date: ");
        textGridData = new GridData(4, 0x1000000, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        Composite dateComposite = toolkit.createComposite(extraSectionClient);
        textGridData = new GridData(4, 0x1000000, true, true);
        textGridData.horizontalSpan = 3;
        dateComposite.setToolTipText("The Due Date for this Review");
        dateComposite.setLayoutData((Object)textGridData);
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.fDueDateText = toolkit.createText(dateComposite, "", 8);
        this.fDueDateText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fDueDateText.setEditable(false);
        toolkit.setBorderStyle(2048);
        Composite dateButtonComposite = toolkit.createComposite(dateComposite);
        textGridData = new GridData(4, 0x1000000, true, true);
        textGridData.horizontalSpan = 1;
        dateButtonComposite.setToolTipText("The Due Date for this Review");
        dateButtonComposite.setLayoutData((Object)textGridData);
        dateButtonComposite.setLayout((Layout)new GridLayout(2, false));
        Button calendarButton = toolkit.createButton(dateButtonComposite, "Update...", 0);
        calendarButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        calendarButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ICalendarDialog dialog = R4EUIDialogFactory.getInstance().getCalendarDialog();
                int result = dialog.open();
                if (result == 0) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
                    Date dialogDate = dialog.getDate();
                    String dialogDateStr = dateFormat.format(dialogDate);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.add(6, -1);
                    if (dialogDate.after(cal.getTime())) {
                        ReviewInputDialog.this.fDueDateText.setText(dialogDateStr);
                        ReviewInputDialog.this.fDueDateValue = dialogDate;
                    } else {
                        UIUtils.displayPastDateError(dialogDate, dialogDateStr);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button clearButton = toolkit.createButton(dateButtonComposite, "Clear", 0);
        clearButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReviewInputDialog.this.fDueDateText.setText("");
                ReviewInputDialog.this.fDueDateValue = null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_PROJECT_DIALOG_VALUE);
        label.setToolTipText("The Project the Reviewed Code belongs to");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fProjectsCombo = new CCombo(extraSectionClient, 2056);
        EList availableProjects = parentGroup.getReviewGroup().getAvailableProjects();
        String[] projects = (String[])availableProjects.toArray((Object[])new String[availableProjects.size()]);
        if (projects.length == 0) {
            this.fProjectsCombo.setEnabled(false);
        } else {
            this.fProjectsCombo.add("");
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String project = stringArray[n2];
                this.fProjectsCombo.add(project);
                ++n2;
            }
        }
        GridData data1 = new GridData(4, 4, true, false);
        data1.horizontalSpan = 3;
        this.fProjectsCombo.setToolTipText("The Project the Reviewed Code belongs to");
        this.fProjectsCombo.setLayoutData((Object)data1);
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_COMPONENTS_DIALOG_VALUE);
        label.setToolTipText("The Components for the Elements being Reviewed");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        EList componentsList = parentGroup.getReviewGroup().getAvailableComponents();
        String[] components = (String[])componentsList.toArray((Object[])new String[componentsList.size()]);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fComponents = new EditableListWidget(toolkit, extraSectionClient, textGridData, null, 0, CCombo.class, components);
        if (components.length == 0) {
            this.fComponents.setEnabled(false);
        }
        this.fComponents.setToolTipText("The Components for the Elements being Reviewed");
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_ENTRY_CRITERIA_DIALOG_VALUE);
        label.setToolTipText("The Entry Criteria for this Review.  This is automatically set to the Parent Review Group Default Value");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fEntryCriteriaTextField = toolkit.createText(extraSectionClient, "", 2562);
        if (parentGroup.getReviewGroup().getDefaultEntryCriteria() != null) {
            this.fEntryCriteriaTextField.setText(parentGroup.getReviewGroup().getDefaultEntryCriteria());
        }
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fReviewNameInputTextField.getLineHeight() * 3;
        this.fEntryCriteriaTextField.setToolTipText("The Entry Criteria for this Review.  This is automatically set to the Parent Review Group Default Value");
        this.fEntryCriteriaTextField.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_OBJECTIVES_DIALOG_VALUE);
        label.setToolTipText("The Objectives of this Review");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fObjectivesTextField = toolkit.createText(extraSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fReviewNameInputTextField.getLineHeight() * 3;
        this.fObjectivesTextField.setToolTipText("The Objectives of this Review");
        this.fObjectivesTextField.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_REFERENCE_MATERIAL_DIALOG_VALUE);
        label.setToolTipText("The Reference Materials to be used for This Review");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fReferenceMaterialTextField = toolkit.createText(extraSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fReviewNameInputTextField.getLineHeight() * 3;
        this.fReferenceMaterialTextField.setToolTipText("The Reference Materials to be used for This Review");
        this.fReferenceMaterialTextField.setLayoutData((Object)textGridData);
        this.fReviewType.setFocus();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    public R4EReviewType getReviewTypeValue() {
        return this.fReviewTypeValue;
    }

    public String getReviewNameValue() {
        return this.fReviewNameValue;
    }

    public String getReviewDescriptionValue() {
        return this.fReviewDescriptionValue;
    }

    public void setDueDate(Date aDate) {
        this.fDueDateValue = aDate;
        if (this.fDueDateValue != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
            this.fDueDateText.setText(dateFormat.format(this.fDueDateValue));
        } else {
            this.fDueDateText.setText("");
        }
    }

    public Date getDueDate() {
        return this.fDueDateValue;
    }

    public String getProjectValue() {
        return this.fProjectValue;
    }

    public String[] getComponentsValues() {
        return this.fComponentsValues;
    }

    public String getEntryCriteriaValue() {
        return this.fEntryCriteriaValue;
    }

    public String getObjectivesValue() {
        return this.fObjectivesValue;
    }

    public String getReferenceMaterialValue() {
        return this.fReferenceMaterialValue;
    }

    private String validateEmptyInput(Text aText) {
        return this.fValidator.isValid(aText.getText());
    }

    private String validateEmptyInput(String aString) {
        return this.fValidator.isValid(aString);
    }

    private String validateReviewExists(Text aReviewName, R4EUIReviewGroup aParentGroup) {
        return ((R4EInputValidator)this.fValidator).isReviewExists(aReviewName.getText(), aParentGroup);
    }
}

