/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ClusterUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ClusterConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getBrokerInfoByAddrSignature;
    private static MBeanParameterInfo[] getBrokerInfoByIdSignature;
    private static MBeanParameterInfo[] changeMasterBrokerSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public ClusterConfig() {
        this.initProps();
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener("imq.cluster.url", this);
    }

    public void setConfigFileURL(String s) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.cluster.url", s);
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("ConfigFileURL", e);
        }
    }

    public String getConfigFileURL() {
        return this.brokerProps.getProperty("imq.cluster.url");
    }

    public String getClusterID() {
        return Globals.getClusterID();
    }

    public Boolean isUseSharedDatabaseForConfigRecord() {
        return this.getUseSharedDatabaseForConfigRecord();
    }

    public Boolean getUseSharedDatabaseForConfigRecord() {
        return Globals.useSharedConfigRecord();
    }

    public Boolean isHighlyAvailable() {
        return this.getHighlyAvailable();
    }

    public Boolean getHighlyAvailable() {
        return Globals.getHAEnabled();
    }

    public CompositeData getLocalBrokerInfo() throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        MQAddress address = cm.getMQAddress();
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(address.toString()));
        }
        catch (Exception e) {
            this.handleGetterException("LocalBrokerInfo", e);
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = ClusterUtil.getConfigCompositeData(cb);
        }
        catch (Exception e) {
            this.handleGetterException("LocalBrokerInfo", e);
        }
        return cd;
    }

    public String getMasterBroker() {
        this.brokerProps = Globals.getConfig().toProperties();
        return this.brokerProps.getProperty("imq.cluster.masterbroker");
    }

    public CompositeData getMasterBrokerInfo() throws MBeanException {
        if (Globals.getHAEnabled()) {
            return null;
        }
        if (Globals.useSharedConfigRecord()) {
            return null;
        }
        String mbAddr = this.getMasterBroker();
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(mbAddr));
        }
        catch (Exception e) {
            this.handleGetterException("MasterBrokerInfo", e);
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = ClusterUtil.getConfigCompositeData(cb);
        }
        catch (Exception e) {
            this.handleGetterException("MasterBrokerInfo", e);
        }
        return cd;
    }

    public String[] getBrokerAddresses() {
        return this.getBrokerIDsOrAddresses(false);
    }

    public String[] getBrokerIDs() {
        if (!Globals.getHAEnabled()) {
            return null;
        }
        return this.getBrokerIDsOrAddresses(true);
    }

    private String[] getBrokerIDsOrAddresses(boolean getID) {
        ClusterManager cm = Globals.getClusterManager();
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        if (cm == null) {
            return null;
        }
        Iterator itr = cm.getConfigBrokers();
        if (itr == null) {
            return null;
        }
        while (itr.hasNext()) {
            ClusteredBroker cb = (ClusteredBroker)itr.next();
            Hashtable bkrInfo = GetClusterHandler.getBrokerClusterInfo(cb, this.logger);
            if (bkrInfo == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            String idOrAddress = getID ? (String)bkrInfo.get("ID") : (String)bkrInfo.get("Address");
            if (idOrAddress == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            al.add(idOrAddress);
        }
        list = new String[al.size()];
        list = al.toArray(list);
        return list;
    }

    public CompositeData[] getBrokerInfo() throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData[] cds = null;
        ArrayList<CompositeData> al = new ArrayList<CompositeData>();
        if (cm == null) {
            return null;
        }
        Iterator itr = cm.getConfigBrokers();
        if (itr == null) {
            return null;
        }
        while (itr.hasNext()) {
            ClusteredBroker cb = (ClusteredBroker)itr.next();
            try {
                CompositeData cd = ClusterUtil.getConfigCompositeData(cb);
                al.add(cd);
            }
            catch (Exception e) {
                this.handleOperationException("getBrokerInfo", e);
            }
        }
        cds = new CompositeData[al.size()];
        cds = al.toArray(cds);
        return cds;
    }

    public CompositeData getBrokerInfoByAddress(String address) throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (cm == null) {
            return null;
        }
        String id = null;
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(address));
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByAddress", e);
        }
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = ClusterUtil.getConfigCompositeData(cb);
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByAddress", e);
        }
        return cd;
    }

    public CompositeData getBrokerInfoByID(String id) throws MBeanException {
        ClusterManager cm = Globals.getClusterManager();
        CompositeData cd = null;
        if (!Globals.getHAEnabled()) {
            return null;
        }
        try {
            if (cm == null) {
                return null;
            }
            ClusteredBroker cb = cm.getBroker(id);
            if (cb == null) {
                return null;
            }
            cd = ClusterUtil.getConfigCompositeData(cb);
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByID", e);
        }
        return cd;
    }

    public CompositeData changeMasterBroker(String oldMasterBroker, String newMasterBroker) throws MBeanException {
        CompositeDataSupport result = null;
        String[] itemNames = new String[]{"Success", "StatusCode", "DetailMessage"};
        String[] itemDescriptions = new String[]{"Success", "StatusCode", "DetailMessage"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.STRING};
        BrokerMQAddress oldmba = null;
        BrokerMQAddress newmba = null;
        try {
            oldmba = BrokerMQAddress.createAddress(oldMasterBroker);
            newmba = BrokerMQAddress.createAddress(newMasterBroker);
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByID", e);
        }
        Boolean success = null;
        Integer statusCode = null;
        Object errorCode = null;
        try {
            Globals.getClusterBroadcast().changeMasterBroker(newmba, oldmba);
            success = Boolean.TRUE;
            statusCode = 0;
            errorCode = "";
        }
        catch (BrokerException e) {
            success = Boolean.FALSE;
            statusCode = e.getStatusCode();
            errorCode = e.getMessage() + "[" + Status.getString(statusCode) + "]";
        }
        Object[] itemValues = new Object[]{success, statusCode, errorCode};
        try {
            CompositeType changeMasterBrokerCompositeType = new CompositeType("ChangeMasterBrokerResult", "ChangeMasterBrokerResult", itemNames, itemDescriptions, itemTypes);
            result = new CompositeDataSupport(changeMasterBrokerCompositeType, itemNames, itemValues);
        }
        catch (Exception e) {
            this.handleOperationException("getBrokerInfoByID", e);
        }
        return result;
    }

    public void reload() throws MBeanException {
        try {
            Globals.getClusterBroadcast().reloadCluster();
        }
        catch (Exception e) {
            this.handleOperationException("reload", e);
        }
    }

    @Override
    public String getMBeanName() {
        return "ClusterConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1000");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        if (name.equals("imq.cluster.url")) {
            String newVal = value;
            String oldVal = this.getConfigFileURL();
            this.notifyAttrChange("ConfigFileURL", newVal, oldVal);
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String attrName, Object newVal, Object oldVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", attrName, newVal.getClass().getName(), oldVal, newVal));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[6];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ConfigFileURL", String.class.getName(), mbr.getString("MB1002"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("ClusterID", String.class.getName(), mbr.getString("MB1003"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("HighlyAvailable", Boolean.class.getName(), mbr.getString("MB1004"), true, false, true);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("UseSharedDatabaseForConfigRecord", Boolean.class.getName(), mbr.getString("MB1272"), true, false, true);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("LocalBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1005"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("MasterBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1006"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("BrokerAddress", String.class.getName(), mbr.getString("MB1011"));
        getBrokerInfoByAddrSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("BrokerID", String.class.getName(), mbr.getString("MB1013"));
        getBrokerInfoByIdSignature = mBeanParameterInfoArray2;
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[2];
        mBeanParameterInfoArray3[0] = new MBeanParameterInfo("oldMasterBroker", String.class.getName(), mbr.getString("MB1270"));
        mBeanParameterInfoArray3[1] = new MBeanParameterInfo("newMasterBroker", String.class.getName(), mbr.getString("MB1271"));
        changeMasterBrokerSignature = mBeanParameterInfoArray3;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[7];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getBrokerAddresses", mbr.getString("MB1007"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBrokerIDs", mbr.getString("MB1008"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getBrokerInfo", mbr.getString("MB1009"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getBrokerInfoByAddress", mbr.getString("MB1010"), getBrokerInfoByAddrSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getBrokerInfoByID", mbr.getString("MB1012"), getBrokerInfoByIdSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("changeMasterBroker", mbr.getString("MB1269"), changeMasterBrokerSignature, CompositeData.class.getName(), 1);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("reload", mbr.getString("MB1014"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

