/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Hashtable;

public class RollbackCommitHandler
extends AdminCmdHandler {
    private static boolean DEBUG = RollbackCommitHandler.getDEBUG();

    public RollbackCommitHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Rollback/Commit transaction " + cmd_props);
        }
        int requestType = (Integer)cmd_props.get("JMQMessageType");
        int status = 200;
        String errMsg = null;
        TransactionUID tid = null;
        TransactionState ts = null;
        TransactionHandler thandler = null;
        if (this.parent.adminPktRtr != null) {
            thandler = (TransactionHandler)this.parent.adminPktRtr.getHandler(48);
        }
        Long id = (Long)cmd_props.get("JMQTransactionID");
        Boolean v = (Boolean)cmd_props.get("JMQProcessActiveConsumers");
        boolean processActiveConsumers = v != null && v != false;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        }
        if (id != null) {
            tid = new TransactionUID(id);
        } else {
            status = 400;
        }
        if (status == 200) {
            TransactionList[] tls = DestinationList.getTransactionList(null);
            TransactionList tl = null;
            for (int i = 0; i < tls.length && (ts = (tl = tls[i]).retrieveState(tid)) == null; ++i) {
            }
            if (ts == null) {
                status = 404;
                errMsg = this.rb.getString("B3113", tid);
            } else if (requestType == 62 && ts.getState() != 5) {
                status = 412;
                errMsg = this.rb.getString("B3115", tid);
            } else if (requestType == 64 && (ts.getState() < 1 || ts.getState() > 5)) {
                status = 412;
                errMsg = this.rb.getString("B3222", tid);
            } else {
                JMQXid xid = tl.UIDToXid(tid);
                if (!(xid != null || Globals.getHAEnabled() && ts.getState() == 5)) {
                    errMsg = requestType == 64 && ts.getState() >= 1 && ts.getState() < 5 ? this.rb.getString("B3100", "Rollback of non-XA transaction " + tid + " in non-PREPARED state is not supported.") : this.rb.getString("B3100", "Could not find Xid for " + tid);
                    status = 500;
                } else if (thandler == null) {
                    errMsg = this.rb.getString("B3100", "Could not locate TransactionHandler");
                    status = 500;
                } else if (requestType == 64) {
                    if (DEBUG) {
                        this.logger.log(4, "Rolling back " + tid + " in state " + ts);
                    }
                    try {
                        if (processActiveConsumers) {
                            this.logger.log(8, this.rb.getKString("B1514", tid));
                            try {
                                thandler.redeliverUnacked(tl, tid, true, true, true, -1, false);
                            }
                            catch (Exception e) {
                                this.logger.logStack(16, this.rb.getKString("B4484", tid, e.getMessage()), e);
                            }
                        }
                        thandler.doRollback(tl, tid, xid, null, ts, null, con, RollbackReason.ADMIN);
                    }
                    catch (BrokerException e) {
                        status = 500;
                        errMsg = e.getMessage();
                    }
                } else if (requestType == 62) {
                    if (DEBUG) {
                        this.logger.log(4, "Committing " + tid + " in state " + ts);
                    }
                    try {
                        thandler.doCommit(tl, tid, xid, 0, ts, null, false, con, null);
                    }
                    catch (BrokerException e) {
                        status = 500;
                        errMsg = e.getMessage();
                    }
                } else {
                    return super.handle(con, cmd_msg, cmd_props);
                }
            }
        }
        this.sendReply(con, cmd_msg, requestType + 1, status, errMsg);
        return true;
    }

    private void sendReply(IMQConnection con, Packet cmd_msg, int replyType, int status, String errMsg) {
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        RollbackCommitHandler.setProperties(reply, replyType, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
    }
}

