/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static final AutoScaleMethod AUTO_SCALE_METHOD_SETTING;
    private static AutoScaleMethod autoScaleMethod;
    private static String autoScaleValue;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";
    private static UseSmoothScalingProvider useSmoothScalingByDefaultProvider;

    static {
        autoScaleValue = System.getProperty(SWT_AUTOSCALE);
        String value = System.getProperty(SWT_AUTOSCALE_METHOD);
        AUTO_SCALE_METHOD_SETTING = AutoScaleMethod.forString(value).orElse(AutoScaleMethod.AUTO);
        autoScaleMethod = AUTO_SCALE_METHOD_SETTING != AutoScaleMethod.AUTO ? AUTO_SCALE_METHOD_SETTING : AutoScaleMethod.NEAREST;
        useSmoothScalingByDefaultProvider = () -> false;
    }

    static String getAutoScaleValue() {
        return autoScaleValue;
    }

    static void setAutoScaleValue(String autoScaleValueArg) {
        autoScaleValue = autoScaleValueArg;
    }

    public static int pixelToPoint(int size, int zoom) {
        if (zoom == 100 || size == -1) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return Math.round((float)size / scaleFactor);
    }

    public static float pixelToPoint(float size, int zoom) {
        if (zoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return size / scaleFactor;
    }

    public static ImageData scaleImageData(Device device, ImageData imageData, int targetZoom, int currentZoom) {
        if (imageData == null || targetZoom == currentZoom || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static ImageData scaleImageData(Device device, ElementAtZoom<ImageData> elementAtZoom, int targetZoom) {
        return DPIUtil.scaleImageData(device, elementAtZoom.element(), targetZoom, elementAtZoom.zoom());
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, float scaleFactor) {
        int width = imageData.width;
        int height = imageData.height;
        int scaledWidth = Math.round((float)width * scaleFactor);
        int scaledHeight = Math.round((float)height * scaleFactor);
        return DPIUtil.scaleImage(device, imageData, Image::drawAtSize, scaledWidth, scaledHeight);
    }

    private static ImageData scaleImage(Device device, final ImageData imageData, final ImageDrawFunction drawFunction, int scaledWidth, int scaledHeight) {
        boolean useSmoothScaling;
        int defaultZoomLevel = 100;
        boolean bl = useSmoothScaling = DPIUtil.isSmoothScalingEnabled() && imageData.getTransparencyType() != 2;
        if (useSmoothScaling) {
            ImageGcDrawer drawer = new ImageGcDrawer(){

                @Override
                public void drawOn(GC gc, int imageWidth, int imageHeight) {
                    gc.setAntialias(1);
                    drawFunction.draw(gc, imageData, imageWidth, imageHeight);
                }

                @Override
                public int getGcStyle() {
                    return 0x40000000;
                }
            };
            Image resultImage = new Image(device, drawer, scaledWidth, scaledHeight);
            ImageData result = resultImage.getImageData(defaultZoomLevel);
            resultImage.dispose();
            return result;
        }
        return imageData.scaledTo(scaledWidth, scaledHeight);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int targetWidth, int targetHeight) {
        return DPIUtil.scaleImage(device, imageData, Image::drawAtSize, targetWidth, targetHeight);
    }

    public static boolean isSmoothScalingEnabled() {
        return autoScaleMethod == AutoScaleMethod.SMOOTH;
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int imageDataZoomFactor) {
        if (deviceZoom == imageDataZoomFactor || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)deviceZoom / (float)imageDataZoomFactor;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static float getScalingFactor(int zoom) {
        return DPIUtil.getScalingFactor(zoom, 100);
    }

    public static float getScalingFactor(int targetZoom, int currentZoom) {
        if (targetZoom <= 0) {
            targetZoom = deviceZoom;
        }
        return (float)targetZoom / (float)currentZoom;
    }

    public static int mapDPIToZoom(int dpi) {
        double zoom = (double)dpi * 100.0 / 96.0;
        int roundedZoom = (int)Math.round(zoom);
        return roundedZoom;
    }

    public static int mapZoomToDPI(int zoom) {
        double dpi = (double)zoom / 100.0 * 96.0;
        int roundedDpi = (int)Math.round(dpi);
        return roundedDpi;
    }

    public static void validateLinearScaling(ImageDataProvider provider) {
        int baseZoom = 100;
        int scaledZoom = 200;
        int scaleFactor = 2;
        ImageData baseImageData = provider.getImageData(100);
        ImageData scaledImageData = provider.getImageData(200);
        if (scaledImageData == null) {
            return;
        }
        if (scaledImageData.width != 2 * baseImageData.width || scaledImageData.height != 2 * baseImageData.height) {
            System.err.println(String.format("***WARNING: ImageData should be linearly scaled across zooms but size is (%d, %d) at 100%% and (%d, %d) at 200%%.", baseImageData.width, baseImageData.height, scaledImageData.width, scaledImageData.height));
            new Error().printStackTrace(System.err);
        }
    }

    public static ElementAtZoom<ImageData> validateAndGetImageDataAtZoom(ImageDataProvider provider, int zoom) {
        ElementAtZoom<ImageData> imageDataAtZoom;
        if (provider == null) {
            SWT.error(4);
        }
        if ((imageDataAtZoom = DPIUtil.getElementAtZoom(z -> provider.getImageData((int)z), zoom)) == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(provider) + "] returns null ImageData at 100% zoom.");
        }
        return imageDataAtZoom;
    }

    public static ElementAtZoom<String> validateAndGetImagePathAtZoom(ImageFileNameProvider provider, int zoom) {
        ElementAtZoom<String> imagePathAtZoom;
        if (provider == null) {
            SWT.error(4);
        }
        if ((imagePathAtZoom = DPIUtil.getElementAtZoom(z -> provider.getImagePath((int)z), zoom)) == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(provider) + "] returns null filename at 100% zoom.");
        }
        return imagePathAtZoom;
    }

    private static <T> ElementAtZoom<T> getElementAtZoom(Function<Integer, T> elementForZoomProvider, int zoom) {
        T dataAt100Percent;
        T dataAt200Percent;
        T dataAt150Percent;
        T dataAtOriginalZoom = elementForZoomProvider.apply(zoom);
        if (dataAtOriginalZoom != null) {
            return new ElementAtZoom<T>(dataAtOriginalZoom, zoom);
        }
        if (zoom > 100 && zoom <= 150 && (dataAt150Percent = elementForZoomProvider.apply(150)) != null) {
            return new ElementAtZoom<T>(dataAt150Percent, 150);
        }
        if (zoom > 100 && (dataAt200Percent = elementForZoomProvider.apply(200)) != null) {
            return new ElementAtZoom<T>(dataAt200Percent, 200);
        }
        if (zoom != 100 && (dataAt100Percent = elementForZoomProvider.apply(100)) != null) {
            return new ElementAtZoom<T>(dataAt100Percent, 100);
        }
        return null;
    }

    public static int getNativeDeviceZoom() {
        return nativeDeviceZoom;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int nativeDeviceZoom) {
        boolean preserveScalingMethod;
        int deviceZoom;
        DPIUtil.nativeDeviceZoom = nativeDeviceZoom;
        DPIUtil.deviceZoom = deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(deviceZoom));
        boolean bl = preserveScalingMethod = SWT.getPlatform().equals("gtk") && deviceZoom == 100;
        if (!preserveScalingMethod && AUTO_SCALE_METHOD_SETTING == AutoScaleMethod.AUTO) {
            autoScaleMethod = useSmoothScalingByDefaultProvider.shouldUseSmoothScaling() ? AutoScaleMethod.SMOOTH : AutoScaleMethod.NEAREST;
        }
    }

    static void setUseSmoothScalingByDefaultProvider(UseSmoothScalingProvider provider) {
        useSmoothScalingByDefaultProvider = provider;
    }

    public static int getZoomForAutoscaleProperty(int nativeDeviceZoom) {
        return DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom, autoScaleValue);
    }

    private static int getZoomForAutoscaleProperty(int nativeDeviceZoom, String autoScaleValue) {
        int zoom = 0;
        if (autoScaleValue != null) {
            if ("false".equalsIgnoreCase(autoScaleValue)) {
                zoom = 100;
            } else if ("half".equalsIgnoreCase(autoScaleValue)) {
                zoom = (int)Math.rint((double)nativeDeviceZoom / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(autoScaleValue)) {
                zoom = Math.round((float)nativeDeviceZoom / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(autoScaleValue)) {
                zoom = nativeDeviceZoom;
            } else {
                try {
                    int zoomValue = Integer.parseInt(autoScaleValue);
                    zoom = Math.max(Math.min(zoomValue, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (zoom == 0) {
            zoom = Math.max((nativeDeviceZoom + 25) / 100 * 100, 100);
        }
        return zoom;
    }

    public static void runWithAutoScaleValue(String autoScaleValue, Runnable runnable) {
        String initialAutoScaleValue = DPIUtil.autoScaleValue;
        DPIUtil.autoScaleValue = autoScaleValue;
        deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        try {
            runnable.run();
        }
        finally {
            DPIUtil.autoScaleValue = initialAutoScaleValue;
            deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        }
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;


        public static Optional<AutoScaleMethod> forString(String s) {
            AutoScaleMethod[] autoScaleMethodArray = AutoScaleMethod.values();
            int n = autoScaleMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                AutoScaleMethod v = autoScaleMethodArray[n2];
                if (v.name().equalsIgnoreCase(s)) {
                    return Optional.of(v);
                }
                ++n2;
            }
            return Optional.empty();
        }
    }

    public record ElementAtZoom<T>(T element, int zoom) {
        public ElementAtZoom {
            if (element == null) {
                SWT.error(4);
            }
            if (zoom <= 0) {
                SWT.error(5);
            }
        }
    }

    @FunctionalInterface
    private static interface ImageDrawFunction {
        public void draw(GC var1, ImageData var2, int var3, int var4);
    }

    @FunctionalInterface
    static interface UseSmoothScalingProvider {
        public boolean shouldUseSmoothScaling();
    }
}

