/**********************************************************************
 * This file is part of "Object Teams Development Tooling"-Software
 * 
 * Copyright 2025 Stephan Herrmann
 * 
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Please visit http://www.eclipse.org/objectteams for updates and contact.
 * 
 * Contributors:
 * 	Stephan Herrmann - Initial API and implementation
 **********************************************************************/
package org.eclipse.objectteams.otdt.internal.debug.adaptor;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

import base org.eclipse.jdt.internal.debug.eval.ast.engine.SourceBasedSourceGenerator;

@SuppressWarnings("restriction")
public team class EvalAdaptor {

	protected class Generator playedBy SourceBasedSourceGenerator {

		@SuppressWarnings("decapsulation")
		boolean isRightType(ASTNode node) <- replace boolean isRightType(ASTNode node);

		callin boolean isRightType(ASTNode node) {
			RoleTypeDeclaration roleType = null;
			if (node instanceof RoleTypeDeclaration) {
				roleType = (RoleTypeDeclaration) node;
				roleType.appearAs(ASTNode.TYPE_DECLARATION);
			}
			try {
				return base.isRightType(node);
			} finally {
				if (roleType != null)
					roleType.appearAs(ASTNode.ROLE_TYPE_DECLARATION);
			}
		}

		@SuppressWarnings("decapsulation")
		buildMethodDeclaration <- replace buildMethodDeclaration;

		callin StringBuilder buildMethodDeclaration(MethodDeclaration methodDeclaration) {
			Flags.asTypeFlag.set(Boolean.FALSE);
			try {
				return base.buildMethodDeclaration(methodDeclaration);
			} finally {
				Flags.asTypeFlag.remove();
			}
		}

		@SuppressWarnings("decapsulation")
		buildTypeDeclaration <- replace buildTypeDeclaration;

		callin StringBuilder buildTypeDeclaration(StringBuilder buffer, TypeDeclaration typeDeclaration) {
			Flags.asTypeFlag.set(Boolean.TRUE);
			try {
				return base.buildTypeDeclaration(buffer, typeDeclaration);
			} finally {
				Flags.asTypeFlag.remove();
			}
		}
	}
}
