/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal.actions;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.OTToggleBreakpointAdapter;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.OTValidBreakpointLocationLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OTBreakpointLocationVerifierJob
extends Job {
    private IDocument fDocument;
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private boolean fBestMatch;
    private IResource fResource;
    private IEditorPart fEditorPart;
    private IEditorStatusLine fStatusLine;

    public OTBreakpointLocationVerifierJob(IDocument document, IJavaLineBreakpoint breakpoint, int lineNumber, boolean bestMatch, String typeName, IType type, IResource resource, IEditorPart editorPart) {
        super(ActionMessages.BreakpointLocationVerifierJob_breakpoint_location);
        this.fDocument = document;
        this.fBreakpoint = breakpoint;
        this.fLineNumber = lineNumber;
        this.fBestMatch = bestMatch;
        this.fTypeName = typeName;
        this.fType = type;
        this.fResource = resource;
        this.fEditorPart = editorPart;
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter(IEditorStatusLine.class);
        this.setSystem(true);
    }

    public IStatus run(IProgressMonitor monitor) {
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        char[] source = this.fDocument.get().toCharArray();
        parser.setSource(source);
        IJavaElement javaElement = JavaCore.create((IResource)this.fResource);
        IJavaProject project = null;
        if (javaElement != null) {
            Hashtable options = JavaCore.getDefaultOptions();
            project = javaElement.getJavaProject();
            String compilerCompliance = "1.5";
            String compilerSource = "1.5";
            if (project != null) {
                compilerCompliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                compilerSource = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            }
            options.put("org.eclipse.jdt.core.compiler.compliance", compilerCompliance);
            options.put("org.eclipse.jdt.core.compiler.source", compilerSource);
            if (project != null) {
                String isPureJava = project.getOption("org.eclipse.objectteams.otdt.compiler.option.pure_java", true);
                options.put("org.eclipse.objectteams.otdt.compiler.option.pure_java", isPureJava);
            }
            parser.setCompilerOptions((Map)options);
        }
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        OTValidBreakpointLocationLocator locator = new OTValidBreakpointLocationLocator(compilationUnit, this.fLineNumber, false, this.fBestMatch);
        compilationUnit.accept((ASTVisitor)locator);
        if (locator.isBindingsRequired() && javaElement != null) {
            Object unitName = null;
            if (this.fType == null) {
                String name = this.fResource.getName();
                if (JavaCore.isJavaLikeFileName((String)name)) {
                    unitName = name;
                }
            } else if (this.fType.isBinary()) {
                String className = this.fType.getClassFile().getElementName();
                int nameLength = className.indexOf(36);
                if (nameLength < 0) {
                    nameLength = className.indexOf(46);
                }
                unitName = className.substring(0, nameLength) + ".java";
            } else {
                unitName = this.fType.getCompilationUnit().getElementName();
            }
            if (unitName != null) {
                parser = ASTParser.newParser((int)AST.getJLSLatest());
                parser.setSource(source);
                parser.setProject(project);
                parser.setUnitName((String)unitName);
                parser.setResolveBindings(true);
                compilationUnit = (CompilationUnit)parser.createAST(null);
                locator = new OTValidBreakpointLocationLocator(compilationUnit, this.fLineNumber, true, this.fBestMatch);
                compilationUnit.accept((ASTVisitor)locator);
            }
        }
        int lineNumber = locator.getLineLocation();
        String typeName = locator.getFullyQualifiedTypeName();
        try {
            switch (locator.getLocationType()) {
                case 1: {
                    return this.manageLineBreakpoint(typeName, lineNumber);
                }
                case 2: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new OTToggleBreakpointAdapter().toggleMethodBreakpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(locator.getMemberOffset(), 0));
                    break;
                }
                case 3: {
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    new OTToggleBreakpointAdapter().toggleWatchpoints((IWorkbenchPart)this.fEditorPart, (ISelection)new TextSelection(locator.getMemberOffset(), 0));
                    break;
                }
                default: {
                    this.report(ActionMessages.BreakpointLocationVerifierJob_not_valid_location);
                    if (this.fBreakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    }
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    public IStatus manageLineBreakpoint(String typeName, int lineNumber) {
        try {
            boolean breakpointExist;
            boolean differentLineNumber = lineNumber != this.fLineNumber;
            IJavaLineBreakpoint breakpoint = JDIDebugModel.lineBreakpointExists((IResource)this.fResource, (String)typeName, (int)lineNumber);
            boolean bl = breakpointExist = breakpoint != null;
            if (this.fBreakpoint == null) {
                if (breakpointExist) {
                    if (differentLineNumber) {
                        this.report(NLS.bind((String)ActionMessages.BreakpointLocationVerifierJob_0, (Object[])new Object[]{Integer.toString(lineNumber)}));
                        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                    }
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpointRemoved, null);
                }
                this.createNewBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
            }
            if (differentLineNumber) {
                if (breakpointExist) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    this.report(NLS.bind((String)ActionMessages.BreakpointLocationVerifierJob_0, (Object[])new Object[]{Integer.toString(lineNumber)}));
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.BreakpointLocationVerifierJob_not_valid_location, null);
                }
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointMovedToValidPosition, null);
            }
            if (!typeName.equals(this.fTypeName)) {
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.BreakpointLocationVerifierJob_breakpointSetToRightType, null);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.BreakpointLocationVerifierJob_breakpoint_set, null);
    }

    private void replaceBreakpoint(int lineNumber, String typeName) throws CoreException {
        this.createNewBreakpoint(lineNumber, typeName);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
    }

    private void createNewBreakpoint(int lineNumber, String typeName) throws CoreException {
        HashMap newAttributes = new HashMap(10);
        if (this.fType != null) {
            try {
                IRegion line = this.fDocument.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, (int)start, (int)end);
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log((Throwable)ble);
            }
        }
        JDIDebugModel.createLineBreakpoint((IResource)this.fResource, (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, newAttributes);
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (OTBreakpointLocationVerifierJob.this.fStatusLine != null) {
                    OTBreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }
}

