/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.objectteams.otdt.debug.OTDebugPlugin;
import org.eclipse.objectteams.otdt.debug.ui.OTDebugUIPlugin;
import org.eclipse.swt.graphics.RGB;

public class OTDebugPreferences
extends AbstractPreferenceInitializer {
    static final String DEBUG_FILTERS_ENABLED_BOOL = "prefs.ot.debugfilters.enabled";
    public static final String DEBUG_CALLIN_STEPPING = "org.eclipse.objectteams.otdt.debug.ui.OtCallinStepping.";
    public static final String[] CALLIN_STEPPING_TOKENS = new String[]{"role", "recurse", "orig"};
    public static final String CALLIN_STEPPING_NONE = "none";
    public static final String[] STEP_FILTER_PACKAGES = new String[]{"de.fub.bytecode.*", "gnu.regexp.*", "org.eclipse.objectteams.otre", "org.eclipse.objectteams.otre.jplis", "org.eclipse.objectteams.otre.util"};

    public void initializeDefaultPreferences() {
        IPreferenceStore prefs = OTDebugUIPlugin.getDefault().getPreferenceStore();
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.objectteams.otdt.debug.ui.OtGeneratedCodeColor", (RGB)new RGB(182, 182, 209));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.objectteams.otdt.debug.ui.OtSpecialCodeColor", (RGB)new RGB(24, 152, 16));
        prefs.setDefault(DEBUG_FILTERS_ENABLED_BOOL, true);
        String[] stringArray = CALLIN_STEPPING_TOKENS;
        int n = CALLIN_STEPPING_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            prefs.setDefault(DEBUG_CALLIN_STEPPING + token, true);
            ++n2;
        }
    }

    public static void propagateFilterFlag(IPreferenceStore prefs) {
        OTDebugPreferences.setUseOTStepFilters(prefs.getBoolean(DEBUG_FILTERS_ENABLED_BOOL));
    }

    public static void setUseOTStepFilters(boolean enable) {
        IPreferenceStore jdiDebugStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore debugUIStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String stepFilterPackages = jdiDebugStore.getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST);
        String newStepFilterPackages = enable ? OTDebugPreferences.addOTStepFilters(stepFilterPackages) : OTDebugPreferences.removeOTStepFilters(stepFilterPackages);
        debugUIStore.setValue(StepFilterManager.PREF_USE_STEP_FILTERS, enable);
        jdiDebugStore.setValue(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, newStepFilterPackages);
        jdiDebugStore.setValue(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS, enable);
    }

    private static String addOTStepFilters(String values) {
        ArrayList<String> result = new ArrayList<String>();
        String[] origEntries = JavaDebugOptionsManager.parseList((String)values);
        int i = 0;
        while (i < origEntries.length) {
            result.add(origEntries[i]);
            ++i;
        }
        String[] entriesToAdd = STEP_FILTER_PACKAGES;
        int i2 = 0;
        while (i2 < entriesToAdd.length) {
            String entryToAdd = entriesToAdd[i2];
            if (!result.contains(entryToAdd)) {
                result.add(entryToAdd);
            }
            ++i2;
        }
        return JavaDebugOptionsManager.serializeList((String[])result.toArray(new String[result.size()]));
    }

    private static String removeOTStepFilters(String values) {
        Object[] entriesToRemove = STEP_FILTER_PACKAGES;
        Arrays.sort(entriesToRemove);
        String[] orig = JavaDebugOptionsManager.parseList((String)values);
        ArrayList<String> result = new ArrayList<String>(entriesToRemove.length);
        int i = 0;
        while (i < orig.length) {
            String origValue = orig[i];
            if (Arrays.binarySearch(entriesToRemove, origValue) < 0) {
                result.add(origValue);
            }
            ++i;
        }
        return JavaDebugOptionsManager.serializeList((String[])result.toArray(new String[result.size()]));
    }

    public static void setCallinStepping(String token, boolean value) {
        IPreferenceStore prefs = OTDebugUIPlugin.getDefault().getPreferenceStore();
        prefs.setValue(DEBUG_CALLIN_STEPPING + token, value);
        OTDebugPlugin.getDefault().setCallinSteppingConfig(OTDebugPreferences.getCallinSteppingString());
    }

    public static String getCallinSteppingString() {
        IPreferenceStore prefs = OTDebugUIPlugin.getDefault().getPreferenceStore();
        Object callinStepping = null;
        String[] stringArray = CALLIN_STEPPING_TOKENS;
        int n = CALLIN_STEPPING_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (prefs.getBoolean(DEBUG_CALLIN_STEPPING + token)) {
                callinStepping = callinStepping == null ? token : (String)callinStepping + "," + token;
            }
            ++n2;
        }
        if (callinStepping == null) {
            callinStepping = CALLIN_STEPPING_NONE;
        }
        return callinStepping;
    }
}

