/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WeavableRegionReader {
    private static final String WEAVABLE_FILE = System.getProperty("ot.weavable");
    private static final String COMMENT_MARKER = "#";
    private static List<String> weavablePrefixes = null;

    public static boolean isWeavable(String className) {
        WeavableRegionReader.ensureInitialized();
        if (weavablePrefixes.isEmpty()) {
            return true;
        }
        for (String prefix : weavablePrefixes) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static synchronized void ensureInitialized() {
        if (weavablePrefixes == null) {
            weavablePrefixes = WeavableRegionReader.readWeavablePrefixes();
        }
    }

    private static List<String> readWeavablePrefixes() {
        if (WEAVABLE_FILE == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(WEAVABLE_FILE)));){
                while (in.ready()) {
                    String nextLine = in.readLine();
                    String nextTeam = nextLine.trim();
                    if (nextTeam.startsWith(COMMENT_MARKER) || nextTeam.equals("")) continue;
                    result.add(nextTeam.trim());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("File input error: weavable file '" + WEAVABLE_FILE + "' can not be found!");
        }
        return result;
    }
}

