/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.AbstractTeam;
import org.eclipse.objectteams.otredyn.bytecode.IBytecodeProvider;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmClassVisitor;
import org.eclipse.objectteams.otredyn.bytecode.asm.Attributes;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class AsmBoundClass
extends AbstractTeam {
    public static final int ASM_API = 393216;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private IBytecodeProvider bytecodeProvider;
    private byte[] bytecode;
    public List<String[]> precedenceses = new ArrayList<String[]>();
    public Set<String> boundBaseClasses;

    protected AsmBoundClass(String name, String id, IBytecodeProvider bytecodeProvider, ClassLoader loader) {
        super(name, id, loader);
        this.bytecodeProvider = bytecodeProvider;
    }

    @Override
    public synchronized void parseBytecode() {
        if (this.parsed) {
            return;
        }
        this.bytecode = this.bytecodeProvider.getBytecode(this.getId());
        if (this.bytecode == null && this.loader != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream stream = this.loader.getResourceAsStream(String.valueOf(this.getInternalName()) + ".class");){
                    if (stream != null) {
                        this.bytecode = this.readAllBytes(stream);
                        this.bytecodeProvider.setBytecode(this.getId(), this.bytecode);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.bytecode == null) {
            return;
        }
        this.parsed = true;
        AsmClassVisitor cv = new AsmClassVisitor(this);
        ClassReader cr = null;
        cr = new ClassReader(this.bytecode);
        cr.accept((ClassVisitor)cv, Attributes.attributes, 0);
        this.bytecode = null;
    }

    public byte[] readAllBytes(InputStream is) throws IOException {
        byte[] buf = new byte[8192];
        int capacity = buf.length;
        int nread = 0;
        while (true) {
            int n;
            if ((n = is.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity <<= 1;
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Requested size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    @Override
    public Collection<String> getBoundBaseClasses() {
        return this.boundBaseClasses;
    }

    protected byte[] allocateAndGetBytecode() {
        if (this.bytecode == null) {
            this.bytecode = this.getBytecode();
        }
        return this.bytecode;
    }

    @Override
    public byte[] getBytecode() {
        return this.bytecodeProvider.getBytecode(this.getId());
    }

    protected void releaseBytecode() {
        this.bytecodeProvider.setBytecode(this.getId(), this.bytecode);
        this.bytecode = null;
    }

    protected IBytecodeProvider getBytecodeProvider() {
        return this.bytecodeProvider;
    }

    protected void setBytecode(byte[] bytecode) {
        if (this.bytecode == null) {
            this.bytecodeProvider.setBytecode(this.getId(), bytecode);
        } else {
            this.bytecode = bytecode;
        }
    }

    @Override
    public int compare(String callinLabel1, String callinLabel2) {
        for (String[] precedences : this.precedenceses) {
            boolean label1Seen = false;
            boolean label2Seen = false;
            String[] stringArray = precedences;
            int n = precedences.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                if (label.equals(callinLabel1)) {
                    if (label2Seen) {
                        return -1;
                    }
                    label1Seen = true;
                } else if (label.equals(callinLabel2)) {
                    if (label1Seen) {
                        return 1;
                    }
                    label2Seen = true;
                }
                ++n2;
            }
        }
        AbstractBoundClass enclosingClass = this.getEnclosingClass();
        if (enclosingClass != null) {
            String singleName = this.getInternalName();
            int pos = singleName.lastIndexOf(36);
            if ((singleName = singleName.substring(pos + 1)).startsWith("__OT__")) {
                singleName = singleName.substring("__OT__".length());
            }
            return enclosingClass.compare(String.valueOf(singleName) + '.' + callinLabel1, String.valueOf(singleName) + '.' + callinLabel2);
        }
        return callinLabel1.compareTo(callinLabel2);
    }
}

