/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlazedListsFilterRowComboBoxDataProvider<T>
extends FilterRowComboBoxDataProvider<T>
implements ListEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GlazedListsFilterRowComboBoxDataProvider.class);
    private static final Scheduler SCHEDULER = new Scheduler("GlazedListsFilterRowComboBoxDataProvider");
    private AtomicBoolean changeHandlingProcessing = new AtomicBoolean(false);
    private EventList<T> baseEventList;

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor) {
        this(bodyLayer, baseCollection, columnAccessor, true);
    }

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor, boolean lazy) {
        super(bodyLayer, baseCollection, columnAccessor, lazy);
        if (baseCollection instanceof EventList) {
            this.baseEventList = (EventList)baseCollection;
            this.baseEventList.addListEventListener((ListEventListener)this);
        } else {
            LOG.error("baseCollection is not of type EventList. List changes can not be tracked.");
        }
    }

    public void listChanged(ListEvent<T> listChanges) {
        if (!this.changeHandlingProcessing.getAndSet(true)) {
            SCHEDULER.schedule(() -> {
                ArrayList<FilterRowComboUpdateEvent> updateEvents = new ArrayList<FilterRowComboUpdateEvent>();
                this.getValueCacheLock().writeLock().lock();
                try {
                    HashMap cacheBefore = new HashMap(this.getValueCache());
                    this.getValueCache().clear();
                    if (!this.lazyLoading) {
                        this.buildValueCache();
                    } else {
                        for (Map.Entry entry : cacheBefore.entrySet()) {
                            this.getValueCache().put((Integer)entry.getKey(), this.collectValues((Integer)entry.getKey()));
                        }
                    }
                    for (Map.Entry entry : cacheBefore.entrySet()) {
                        updateEvents.add(this.buildUpdateEvent((Integer)entry.getKey(), (List)entry.getValue(), (List)this.getValueCache().get(entry.getKey())));
                    }
                    this.changeHandlingProcessing.set(false);
                }
                finally {
                    this.getValueCacheLock().writeLock().unlock();
                }
                if (this.isUpdateEventsEnabled()) {
                    for (FilterRowComboUpdateEvent event : updateEvents) {
                        this.fireCacheUpdateEvent(event);
                    }
                }
            }, 100L);
        }
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (this.cachingEnabled && event instanceof CellVisualChangeEvent) {
            SCHEDULER.schedule(() -> {
                this.getValueCacheLock().writeLock().lock();
                try {
                    int column = ((CellVisualChangeEvent)event).getColumnPosition();
                    List cacheBefore = (List)this.getValueCache().get(column);
                    if (!this.lazyLoading || cacheBefore != null) {
                        this.getValueCache().put(column, this.collectValues(column));
                    }
                    if (this.isUpdateEventsEnabled()) {
                        this.fireCacheUpdateEvent(this.buildUpdateEvent(column, cacheBefore, (List)this.getValueCache().get(column)));
                    }
                }
                finally {
                    this.getValueCacheLock().writeLock().unlock();
                }
            }, 0L);
        }
    }

    public void dispose() {
        super.dispose();
        SCHEDULER.shutdownNow();
    }
}

