/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularArrayList<T>
extends AbstractList<T> {
    int head = 0;
    int size = 0;
    Object[] values = new Object[10];
    int arrayLength = this.values.length;

    @Override
    public T get(int index) {
        return (T)this.values[this.toCircularIndex(index)];
    }

    @Override
    public void add(int index, T element) {
        this.growIfNecessary();
        int indexToAdd = this.toCircularIndex(index);
        int distToHead = this.distanceToHead(indexToAdd);
        int distToTail = this.distanceToTail(indexToAdd);
        if (distToTail <= distToHead) {
            int tail = this.tail();
            this.shift(indexToAdd, tail, 1);
            this.values[indexToAdd] = element;
        } else {
            this.shift(this.head, indexToAdd, -1);
            this.values[this.modIndex((int)(indexToAdd - 1))] = element;
            this.head = this.modIndex(this.head - 1);
        }
        ++this.size;
    }

    int tail() {
        return this.modIndex(this.head + this.size);
    }

    void growIfNecessary() {
        int size = this.size();
        if (size < this.arrayLength) {
            return;
        }
        Object[] biggerValues = new Object[this.values.length * 2];
        int tail = this.tail();
        if (this.head < tail) {
            System.arraycopy(this.values, this.head, biggerValues, 0, tail - this.head);
        } else {
            System.arraycopy(this.values, this.head, biggerValues, 0, this.arrayLength - this.head);
            System.arraycopy(this.values, 0, biggerValues, this.arrayLength - this.head, tail);
        }
        this.values = biggerValues;
        this.arrayLength = biggerValues.length;
        this.head = 0;
    }

    @Override
    public T remove(int index) {
        int indexToRemove = this.toCircularIndex(index);
        int distToHead = this.distanceToHead(indexToRemove);
        int distToTail = this.distanceToTail(indexToRemove);
        T removed = this.get(index);
        if (distToTail < distToHead) {
            int tail = this.tail();
            this.shift(indexToRemove + 1, tail, -1);
            this.values[this.modIndex((int)(tail - 1))] = null;
        } else {
            this.shift(this.head, indexToRemove, 1);
            this.values[this.head] = null;
            this.head = this.modIndex(this.head + 1);
        }
        --this.size;
        return removed;
    }

    void shift(int first, int last, int distance) {
        if (distance != 1 && distance != -1) {
            throw new IllegalArgumentException();
        }
        if (first == last) {
            return;
        }
        if (last == 0) {
            last = this.arrayLength;
        }
        if (first > last && last != 0) {
            if (distance == 1) {
                System.arraycopy(this.values, 0, this.values, 1, last);
                this.values[0] = this.values[this.arrayLength - 1];
                System.arraycopy(this.values, first, this.values, first + 1, this.arrayLength - first - 1);
                this.values[first] = null;
            } else if (distance == -1) {
                System.arraycopy(this.values, first, this.values, first - 1, this.arrayLength - first);
                this.values[this.arrayLength - 1] = this.values[0];
                System.arraycopy(this.values, 1, this.values, 0, last - 1);
                this.values[last - 1] = null;
            }
        } else if (distance == -1 && first == 0) {
            this.values[this.arrayLength - 1] = this.values[0];
            System.arraycopy(this.values, 1, this.values, 0, last - 1);
            this.values[last - 1] = null;
        } else if (distance == 1 && last == this.arrayLength) {
            this.values[0] = this.values[this.arrayLength - 1];
            System.arraycopy(this.values, first, this.values, first + 1, last - first - 1);
            this.values[first] = null;
        } else if (distance == 1) {
            System.arraycopy(this.values, first, this.values, first + 1, last - first);
            this.values[first] = null;
        } else if (distance == -1) {
            System.arraycopy(this.values, first, this.values, first - 1, last - first);
            this.values[last - 1] = null;
        }
    }

    private int distanceToTail(int index) {
        int tail = this.tail();
        return index <= tail ? tail - index : tail + this.arrayLength - index;
    }

    private int distanceToHead(int index) {
        return index >= this.head ? index - this.head : index + this.arrayLength - this.head;
    }

    @Override
    public int size() {
        return this.size;
    }

    int toCircularIndex(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " on List of size: " + this.size);
        }
        return this.modIndex(index + this.head);
    }

    int modIndex(int value) {
        return (value + this.arrayLength) % this.arrayLength;
    }
}

