/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.preserve;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class Selections<T> {
    private Map<Serializable, Row<T>> selectedRows = new HashMap<Serializable, Row<T>>();
    private Map<Integer, Column> selectedColumns = new HashMap<Integer, Column>();

    Selections() {
    }

    void select(Serializable rowId, T rowObject, int columnPosition) {
        Row<T> row = this.retrieveRow(rowId, rowObject);
        row.addItem(columnPosition);
        Column column = this.retrieveColumn(columnPosition);
        column.addItem(rowId);
    }

    void deselect(Serializable rowId, int columnPosition) {
        Column column;
        Row<T> row = this.getSelectedColumns(rowId);
        if (row != null) {
            row.removeItem(columnPosition);
            if (!row.hasSelection()) {
                this.selectedRows.remove(rowId);
            }
        }
        if ((column = this.getSelectedRows(columnPosition)) != null) {
            column.removeItem(rowId);
            if (!column.hasSelection()) {
                this.selectedColumns.remove(columnPosition);
            }
        }
    }

    void deselectRow(Serializable rowId) {
        Row<T> row = this.getSelectedColumns(rowId);
        if (row != null) {
            row.clearItems();
            this.selectedRows.remove(rowId);
        }
        HashSet<Integer> toRemove = new HashSet<Integer>();
        for (Map.Entry<Integer, Column> entry : this.selectedColumns.entrySet()) {
            entry.getValue().removeItem(rowId);
            if (entry.getValue().hasSelection()) continue;
            toRemove.add(entry.getKey());
        }
        for (Integer key : toRemove) {
            this.selectedColumns.remove(key);
        }
    }

    void deselectColumn(int columnPosition) {
        Column column = this.getSelectedRows(columnPosition);
        if (column != null) {
            column.clearItems();
            this.selectedColumns.remove(columnPosition);
        }
        HashSet<Serializable> toRemove = new HashSet<Serializable>();
        for (Map.Entry<Serializable, Row<T>> entry : this.selectedRows.entrySet()) {
            entry.getValue().removeItem(columnPosition);
            if (entry.getValue().hasSelection()) continue;
            toRemove.add(entry.getKey());
        }
        for (Serializable key : toRemove) {
            this.selectedRows.remove(key);
        }
    }

    void updateColumnsForRemoval(int columnPosition) {
        int maxColumn = 0;
        for (Integer pos : this.selectedColumns.keySet()) {
            maxColumn = Math.max(maxColumn, pos);
        }
        int i = columnPosition + 1;
        while (i <= maxColumn) {
            Column column = this.selectedColumns.get(i);
            if (column != null) {
                this.selectedColumns.put(i - 1, new Column(i - 1, column.getItems()));
                this.selectedColumns.remove(i);
                for (Row<T> row : this.selectedRows.values()) {
                    HashSet<Integer> toRemove = new HashSet<Integer>();
                    HashSet<Integer> toAdd = new HashSet<Integer>();
                    for (Integer col : row.getItems()) {
                        if (col > i) continue;
                        toRemove.add(i);
                        toAdd.add(i - 1);
                    }
                    row.getItems().removeAll(toRemove);
                    row.getItems().addAll(toAdd);
                }
            }
            ++i;
        }
    }

    void updateColumnsForAddition(int columnPosition) {
        int maxColumn = 0;
        for (Integer pos : this.selectedColumns.keySet()) {
            maxColumn = Math.max(maxColumn, pos);
        }
        int i = maxColumn;
        while (i >= columnPosition) {
            Column column = this.selectedColumns.get(i);
            if (column != null) {
                this.selectedColumns.put(i + 1, new Column(i + 1, column.getItems()));
                this.selectedColumns.remove(i);
                for (Row<T> row : this.selectedRows.values()) {
                    HashSet<Integer> toRemove = new HashSet<Integer>();
                    HashSet<Integer> toAdd = new HashSet<Integer>();
                    for (Integer col : row.getItems()) {
                        if (col < i) continue;
                        toRemove.add(i);
                        toAdd.add(i + 1);
                    }
                    row.getItems().removeAll(toRemove);
                    row.getItems().addAll(toAdd);
                }
            }
            --i;
        }
    }

    void clear() {
        this.selectedRows.clear();
        this.selectedColumns.clear();
    }

    Collection<Row<T>> getRows() {
        return this.selectedRows.values();
    }

    List<Integer> getColumnPositions() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.selectedColumns.keySet());
        Collections.sort(keys);
        return keys;
    }

    Column getSelectedRows(int columnPosition) {
        return this.selectedColumns.get(columnPosition);
    }

    Row<T> getSelectedColumns(Serializable rowId) {
        return this.selectedRows.get(rowId);
    }

    Collection<CellPosition<T>> getSelections() {
        ArrayList<CellPosition<T>> selectedCells = new ArrayList<CellPosition<T>>();
        for (Row<T> row : this.selectedRows.values()) {
            for (Integer columnPosition : row.getItems()) {
                CellPosition<T> cell = new CellPosition<T>(row.getRowObject(), columnPosition);
                selectedCells.add(cell);
            }
        }
        return selectedCells;
    }

    boolean isSelected(Serializable rowId, int columnPosition) {
        if (this.isRowSelected(rowId)) {
            return this.getSelectedColumns(rowId).contains(columnPosition);
        }
        return false;
    }

    boolean isRowSelected(Serializable rowId) {
        return this.selectedRows.containsKey(rowId);
    }

    boolean isEmpty() {
        return this.selectedRows.isEmpty();
    }

    private Row<T> retrieveRow(Serializable rowId, T rowObject) {
        Row<T> row = this.getSelectedColumns(rowId);
        if (row == null) {
            row = new Row<T>(rowId, rowObject);
            this.selectedRows.put(rowId, row);
        }
        return row;
    }

    private Column retrieveColumn(int columnPosition) {
        Column column = this.getSelectedRows(columnPosition);
        if (column == null) {
            column = new Column(columnPosition);
            this.selectedColumns.put(columnPosition, column);
        }
        return column;
    }

    static class CellPosition<T> {
        private final int columnPosition;
        private final T rowObject;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnPosition;
            result = 31 * result + (this.rowObject == null ? 0 : this.rowObject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellPosition other = (CellPosition)obj;
            if (this.columnPosition != other.columnPosition) {
                return false;
            }
            return !(this.rowObject == null ? other.rowObject != null : !this.rowObject.equals(other.rowObject));
        }

        CellPosition(T rowObject, int columnPosition) {
            this.rowObject = rowObject;
            this.columnPosition = columnPosition;
        }

        T getRowObject() {
            return this.rowObject;
        }

        Integer getColumnPosition() {
            return this.columnPosition;
        }
    }

    static class Column
    extends Line<Integer, Serializable> {
        Column(Integer columnPosition) {
            super(columnPosition);
        }

        Column(Integer columnPosition, Collection<Serializable> content) {
            super(columnPosition, content);
        }
    }

    static class Line<I, S> {
        private final I lineId;
        private HashSet<S> content = new HashSet();

        Line(I lineId) {
            this.lineId = lineId;
        }

        Line(I lineId, Collection<S> content) {
            this.lineId = lineId;
            this.content.addAll(content);
        }

        Collection<S> getItems() {
            return this.content;
        }

        void addItem(S item) {
            this.content.add(item);
        }

        void removeItem(S item) {
            this.content.remove(item);
        }

        void clearItems() {
            this.content.clear();
        }

        boolean contains(S item) {
            return this.content.contains(item);
        }

        boolean hasSelection() {
            return !this.content.isEmpty();
        }

        I getId() {
            return this.lineId;
        }
    }

    static class Row<R>
    extends Line<Serializable, Integer> {
        private final R rowObject;

        Row(Serializable rowId, R rowObject) {
            super(rowId);
            this.rowObject = rowObject;
        }

        R getRowObject() {
            return this.rowObject;
        }
    }
}

