/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class MultiColumnReorderCommand
implements ILayerCommand {
    private List<ColumnPositionCoordinate> fromColumnPositionCoordinates;
    protected ColumnPositionCoordinate toColumnPositionCoordinate;
    private boolean reorderToLeftEdge;
    private boolean reorderByIndex = false;

    public MultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPosition) {
        this(layer, fromColumnPositions, toColumnPosition < layer.getColumnCount() ? toColumnPosition : toColumnPosition - 1, toColumnPosition < layer.getColumnCount());
    }

    public MultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        this.fromColumnPositionCoordinates = new ArrayList<ColumnPositionCoordinate>(fromColumnPositions.size());
        for (Integer fromColumnPosition : fromColumnPositions) {
            this.fromColumnPositionCoordinates.add(new ColumnPositionCoordinate(layer, fromColumnPosition));
        }
        this.toColumnPositionCoordinate = new ColumnPositionCoordinate(layer, toColumnPosition);
        this.reorderToLeftEdge = reorderToLeftEdge;
    }

    protected MultiColumnReorderCommand(MultiColumnReorderCommand command) {
        this.fromColumnPositionCoordinates = new ArrayList<ColumnPositionCoordinate>(command.fromColumnPositionCoordinates);
        this.toColumnPositionCoordinate = command.toColumnPositionCoordinate;
        this.reorderToLeftEdge = command.reorderToLeftEdge;
        this.reorderByIndex = command.reorderByIndex;
    }

    public List<Integer> getFromColumnPositions() {
        ArrayList<Integer> fromColumnPositions = new ArrayList<Integer>(this.fromColumnPositionCoordinates.size());
        for (ColumnPositionCoordinate fromColumnPositionCoordinate : this.fromColumnPositionCoordinates) {
            fromColumnPositions.add(fromColumnPositionCoordinate.getColumnPosition());
        }
        return fromColumnPositions;
    }

    public int getToColumnPosition() {
        return this.toColumnPositionCoordinate.getColumnPosition();
    }

    public boolean isReorderToLeftEdge() {
        return this.reorderToLeftEdge;
    }

    public boolean isReorderByIndex() {
        return this.reorderByIndex;
    }

    public void setReorderByIndex(boolean reorderByIndex) {
        this.reorderByIndex = reorderByIndex;
    }

    public void toggleCoordinateByEdge() {
        if (this.reorderToLeftEdge && this.toColumnPositionCoordinate.columnPosition > 0) {
            --this.toColumnPositionCoordinate.columnPosition;
            this.reorderToLeftEdge = false;
        } else if (!this.reorderToLeftEdge && this.toColumnPositionCoordinate.columnPosition < this.toColumnPositionCoordinate.getLayer().getColumnCount() - 1) {
            ++this.toColumnPositionCoordinate.columnPosition;
            this.reorderToLeftEdge = true;
        }
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        ArrayList<ColumnPositionCoordinate> convertedFromColumnPositionCoordinates = new ArrayList<ColumnPositionCoordinate>(this.fromColumnPositionCoordinates.size());
        for (ColumnPositionCoordinate fromColumnPositionCoordinate : this.fromColumnPositionCoordinates) {
            if (!this.reorderByIndex) {
                ColumnPositionCoordinate convertedFromColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(fromColumnPositionCoordinate, targetLayer);
                if (convertedFromColumnPositionCoordinate == null) continue;
                convertedFromColumnPositionCoordinates.add(convertedFromColumnPositionCoordinate);
                continue;
            }
            convertedFromColumnPositionCoordinates.add(fromColumnPositionCoordinate);
        }
        ColumnPositionCoordinate targetToColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.toColumnPositionCoordinate, targetLayer);
        if (convertedFromColumnPositionCoordinates.size() > 0 && targetToColumnPositionCoordinate != null) {
            this.fromColumnPositionCoordinates = convertedFromColumnPositionCoordinates;
            this.toColumnPositionCoordinate = targetToColumnPositionCoordinate;
            return true;
        }
        return false;
    }

    @Override
    public MultiColumnReorderCommand cloneCommand() {
        return new MultiColumnReorderCommand(this);
    }
}

