/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowCommandLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class RowHideShowLayer
extends AbstractRowHideShowLayer
implements IRowHideShowCommandLayer,
IRowHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_INDEXES = ".hiddenRowIndexes";
    private final Set<Integer> hiddenRowIndexes = new TreeSet<Integer>();

    public RowHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerCommandHandler(new MultiRowHideCommandHandler(this));
        this.registerCommandHandler(new RowHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllRowsCommandHandler(this));
        this.registerCommandHandler(new MultiRowShowCommandHandler(this));
        this.registerCommandHandler(new RowPositionHideCommandHandler(this));
        this.registerCommandHandler(new RowShowCommandHandler(this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        Collection<StructuralDiff> rowDiffs;
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isVerticalStructureChanged() && (rowDiffs = structuralChangeEvent.getRowDiffs()) != null && !rowDiffs.isEmpty() && !StructuralChangeEventHelper.isReorder(rowDiffs)) {
            StructuralChangeEventHelper.handleRowDelete(rowDiffs, this.underlyingLayer, this.hiddenRowIndexes, false);
            StructuralChangeEventHelper.handleRowInsert(rowDiffs, this.underlyingLayer, this.hiddenRowIndexes, false);
        }
        super.handleLayerEvent(event);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenRowIndexes.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.hiddenRowIndexes) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_INDEXES, strBuilder.toString());
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenRowIndexes.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.hiddenRowIndexes.add(Integer.valueOf(index));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int downRowIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        int upRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
        if (this.isRowIndexHidden(upRowIndex)) {
            configLabels.addLabel("ROW_TOP_HIDDEN");
        }
        if (this.isRowIndexHidden(downRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1))) {
            configLabels.addLabel("ROW_BOTTOM_HIDDEN");
        }
        return configLabels;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return this.hiddenRowIndexes;
    }

    @Override
    public void hideRowPositions(Collection<Integer> rowPositions) {
        HashSet<Integer> rowIndexes = new HashSet<Integer>();
        for (Integer rowPosition : rowPositions) {
            rowIndexes.add(this.getRowIndexByPosition(rowPosition));
        }
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, (Collection<Integer>)rowIndexes));
    }

    @Override
    public void hideRowIndexes(Collection<Integer> rowIndexes) {
        HashSet<Integer> rowPositions = new HashSet<Integer>();
        for (Integer rowIndex : rowIndexes) {
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
        }
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)rowPositions, rowIndexes));
    }

    @Override
    public void showRowIndexes(Collection<Integer> rowIndexes) {
        this.hiddenRowIndexes.removeAll(rowIndexes);
        this.invalidateCache();
        Collection<Integer> positions = this.getRowPositionsByIndexes(rowIndexes);
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, positions));
    }

    @Override
    public void showRowPosition(int rowPosition, boolean showToTop, boolean showAll) {
        HashSet<Integer> rowIndexes = new HashSet<Integer>();
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        if (showToTop) {
            int topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(topRowIndex)) {
                    rowIndexes.add(topRowIndex);
                    topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - ++move);
                }
            } else if (this.isRowIndexHidden(topRowIndex)) {
                rowIndexes.add(topRowIndex);
            }
        } else {
            int bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(bottomRowIndex)) {
                    rowIndexes.add(bottomRowIndex);
                    bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + ++move);
                }
            } else if (this.isRowIndexHidden(bottomRowIndex)) {
                rowIndexes.add(bottomRowIndex);
            }
        }
        if (!rowIndexes.isEmpty()) {
            this.showRowIndexes(rowIndexes);
        }
    }

    @Override
    public void showAllRows() {
        ArrayList<Integer> hiddenRows = new ArrayList<Integer>(this.hiddenRowIndexes);
        this.hiddenRowIndexes.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, this.getRowPositionsByIndexes(hiddenRows)));
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("ROW_TOP_HIDDEN");
        result.add("ROW_BOTTOM_HIDDEN");
        return result;
    }
}

