/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.UpdateRowGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;

public class RowGroupExpandCollapseLayer
extends AbstractRowHideShowLayer {
    private final Map<GroupModel.Group, Collection<Integer>> hidden = new HashMap<GroupModel.Group, Collection<Integer>>();

    public RowGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowGroupExpandCommand) {
            List<GroupModel.Group> groups = ((RowGroupExpandCommand)command).getGroups();
            TreeSet<Integer> shownIndexes = new TreeSet<Integer>();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable() || !group.isCollapsed()) continue;
                group.setCollapsed(false);
                Collection<Integer> rowIndexes = this.hidden.get(group);
                this.hidden.remove(group);
                shownIndexes.addAll(rowIndexes);
            }
            if (!shownIndexes.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, this.getRowPositionsByIndexes(shownIndexes)));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof RowGroupCollapseCommand) {
            GroupModel groupModel = ((RowGroupCollapseCommand)command).getGroupModel();
            List<GroupModel.Group> groups = ((RowGroupCollapseCommand)command).getGroups();
            Collections.sort(groups, new Comparator<GroupModel.Group>(){

                @Override
                public int compare(GroupModel.Group o1, GroupModel.Group o2) {
                    return o2.getVisibleStartPosition() - o1.getVisibleStartPosition();
                }
            });
            TreeSet<Integer> hiddenPositions = new TreeSet<Integer>();
            TreeSet<Integer> hiddenIndexes = new TreeSet<Integer>();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable()) continue;
                TreeSet<Integer> rowIndexes = new TreeSet<Integer>();
                if (!group.isCollapsed()) {
                    rowIndexes.addAll(group.getVisibleIndexes());
                    group.setCollapsed(true);
                } else if (!this.hidden.containsKey(group)) {
                    for (int member : group.getMembers()) {
                        int pos = groupModel.getPositionByIndex(member);
                        if (pos <= -1) continue;
                        rowIndexes.add(pos);
                    }
                }
                this.modifyForVisible(group, rowIndexes);
                this.hidden.put(group, rowIndexes);
                hiddenPositions.addAll(this.getRowPositionsByIndexes(rowIndexes));
                hiddenIndexes.addAll(rowIndexes);
            }
            if (!hiddenPositions.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)hiddenPositions, (Collection<Integer>)hiddenIndexes));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof UpdateRowGroupCollapseCommand) {
            UpdateRowGroupCollapseCommand cmd = (UpdateRowGroupCollapseCommand)command;
            GroupModel.Group group = cmd.getGroup();
            Collection<Integer> hiddenRowIndexes = this.hidden.get(group);
            if (group.getVisibleIndexes().size() + hiddenRowIndexes.size() <= group.getOriginalSpan()) {
                Collection<Integer> indexesToHide = cmd.getIndexesToHide();
                Collection<Integer> indexesToShow = cmd.getIndexesToShow();
                indexesToHide.removeAll(hiddenRowIndexes);
                this.modifyForVisible(group, indexesToHide);
                Collection<Integer> hiddenPositions = this.getRowPositionsByIndexes(indexesToHide);
                hiddenRowIndexes.addAll(indexesToHide);
                hiddenRowIndexes.removeAll(indexesToShow);
                this.invalidateCache();
                this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, hiddenPositions, indexesToHide));
            }
            return true;
        }
        return super.doCommand(command);
    }

    private void modifyForVisible(GroupModel.Group group, Collection<Integer> rowIndexes) {
        Collection<Integer> staticIndexes = group.getStaticIndexes();
        if (staticIndexes.isEmpty()) {
            rowIndexes.remove(group.getVisibleStartIndex());
        } else {
            rowIndexes.removeAll(staticIndexes);
        }
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        for (Collection<Integer> indexes : this.hidden.values()) {
            if (!indexes.contains(rowIndex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        TreeSet<Integer> hiddenRowIndexes = new TreeSet<Integer>();
        for (Collection<Integer> indexes : this.hidden.values()) {
            hiddenRowIndexes.addAll(indexes);
        }
        return hiddenRowIndexes;
    }
}

