/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.UpdateColumnGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;

public class ColumnGroupExpandCollapseLayer
extends AbstractColumnHideShowLayer {
    private final Map<GroupModel.Group, Collection<Integer>> hidden = new HashMap<GroupModel.Group, Collection<Integer>>();

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ColumnGroupExpandCommand) {
            List<GroupModel.Group> groups = ((ColumnGroupExpandCommand)command).getGroups();
            TreeSet<Integer> shownIndexes = new TreeSet<Integer>();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable() || !group.isCollapsed()) continue;
                group.setCollapsed(false);
                Collection<Integer> columnIndexes = this.hidden.get(group);
                this.hidden.remove(group);
                shownIndexes.addAll(columnIndexes);
            }
            if (!shownIndexes.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new ShowColumnPositionsEvent(this, this.getColumnPositionsByIndexes(shownIndexes)));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof ColumnGroupCollapseCommand) {
            GroupModel groupModel = ((ColumnGroupCollapseCommand)command).getGroupModel();
            List<GroupModel.Group> groups = ((ColumnGroupCollapseCommand)command).getGroups();
            Collections.sort(groups, new Comparator<GroupModel.Group>(){

                @Override
                public int compare(GroupModel.Group o1, GroupModel.Group o2) {
                    return o2.getVisibleStartPosition() - o1.getVisibleStartPosition();
                }
            });
            TreeSet<Integer> hiddenPositions = new TreeSet<Integer>();
            TreeSet<Integer> hiddenIndexes = new TreeSet<Integer>();
            for (GroupModel.Group group : groups) {
                if (group == null || !group.isCollapseable()) continue;
                TreeSet<Integer> columnIndexes = new TreeSet<Integer>();
                if (!group.isCollapsed()) {
                    columnIndexes.addAll(group.getVisibleIndexes());
                    group.setCollapsed(true);
                } else if (!this.hidden.containsKey(group)) {
                    for (int member : group.getMembers()) {
                        int pos = groupModel.getPositionByIndex(member);
                        if (pos <= -1) continue;
                        columnIndexes.add(pos);
                    }
                }
                this.modifyForVisible(group, columnIndexes);
                this.hidden.put(group, columnIndexes);
                hiddenPositions.addAll(this.getColumnPositionsByIndexes(columnIndexes));
                hiddenIndexes.addAll(columnIndexes);
            }
            if (!hiddenPositions.isEmpty()) {
                this.invalidateCache();
                this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, (Collection<Integer>)hiddenPositions, (Collection<Integer>)hiddenIndexes));
            } else {
                this.fireLayerEvent(new VisualRefreshEvent(this));
            }
            return true;
        }
        if (command instanceof UpdateColumnGroupCollapseCommand) {
            UpdateColumnGroupCollapseCommand cmd = (UpdateColumnGroupCollapseCommand)command;
            GroupModel.Group group = cmd.getGroup();
            Collection<Integer> hiddenColumnIndexes = this.hidden.get(group);
            if (group.getVisibleIndexes().size() + hiddenColumnIndexes.size() <= group.getOriginalSpan()) {
                Collection<Integer> indexesToHide = cmd.getIndexesToHide();
                Collection<Integer> indexesToShow = cmd.getIndexesToShow();
                indexesToHide.removeAll(hiddenColumnIndexes);
                this.modifyForVisible(group, indexesToHide);
                Collection<Integer> hiddenPositions = this.getColumnPositionsByIndexes(indexesToHide);
                hiddenColumnIndexes.addAll(indexesToHide);
                hiddenColumnIndexes.removeAll(indexesToShow);
                this.invalidateCache();
                this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, hiddenPositions, indexesToHide));
            }
            return true;
        }
        return super.doCommand(command);
    }

    private void modifyForVisible(GroupModel.Group group, Collection<Integer> columnIndexes) {
        Collection<Integer> staticIndexes = group.getStaticIndexes();
        if (staticIndexes.isEmpty()) {
            columnIndexes.remove(group.getVisibleStartIndex());
        } else {
            columnIndexes.removeAll(staticIndexes);
        }
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        for (Collection<Integer> indexes : this.hidden.values()) {
            if (!indexes.contains(columnIndex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        TreeSet<Integer> hiddenColumnIndexes = new TreeSet<Integer>();
        for (Collection<Integer> indexes : this.hidden.values()) {
            hiddenColumnIndexes.addAll(indexes);
        }
        return hiddenColumnIndexes;
    }
}

