/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing;

import java.util.Date;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.validate.DataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.dataset.EventData;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.CrossValidationGridExample;

class EventDataValidator
extends DataValidator {
    private IRowDataProvider<EventData> bodyDataProvider;

    EventDataValidator(IRowDataProvider<EventData> bodyDataProvider) {
        this.bodyDataProvider = bodyDataProvider;
    }

    public boolean validate(int columnIndex, int rowIndex, Object newValue) {
        EventData rowObject = (EventData)this.bodyDataProvider.getRowObject(rowIndex);
        Date fromDate = rowObject.getFromDate();
        Date toDate = rowObject.getToDate();
        if (columnIndex == 3) {
            fromDate = (Date)newValue;
        } else if (columnIndex == 4) {
            toDate = (Date)newValue;
        }
        if (!CrossValidationGridExample.isEventDataValid(fromDate, toDate)) {
            throw new ValidationFailedException("fromDate is not before toDate");
        }
        return true;
    }
}

