/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._103_Events;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.dataset.pricing.ColumnHeaders;
import org.eclipse.nebula.widgets.nattable.dataset.pricing.PricingDataBean;
import org.eclipse.nebula.widgets.nattable.dataset.pricing.PricingDataBeanGenerator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.ColumnStructureUpdatesExampleGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ColumnStructureUpdatesGridExample
extends AbstractNatExample {
    private EventList<PricingDataBean> rowObjectsGlazedList;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(new ColumnStructureUpdatesGridExample());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        EventList eventList = GlazedLists.eventList((Collection)PricingDataBeanGenerator.getData((int)10));
        this.rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
        Map<String, String> propertyToLabelMap = this.populateColHeaderPropertiesToLabelsMap();
        String[] propertyNames = propertyToLabelMap.keySet().toArray(ArrayUtil.STRING_TYPE_ARRAY);
        ConfigRegistry configRegistry = new ConfigRegistry();
        final ColumnStructureUpdatesExampleGridLayer<PricingDataBean> glazedListsGridLayer = new ColumnStructureUpdatesExampleGridLayer<PricingDataBean>(this.rowObjectsGlazedList, propertyNames, propertyToLabelMap, (IConfigRegistry)configRegistry, true);
        NatTable natTable = new NatTable(parent, glazedListsGridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.getConfigRegistry().registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", "ODD_BODY");
        natTable.getConfigRegistry().registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", "EVEN_BODY");
        natTable.configure();
        glazedListsGridLayer.bodyDataProvider.setColumnCount(2);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button button = new Button(composite, 8);
        button.setText("Clear list, add 6 items, Change column count");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.getReadWriteLock().writeLock().lock();
                try {
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.clear();
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    glazedListsGridLayer.bodyDataProvider.setColumnCount(8);
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.add((Object)new PricingDataBean());
                }
                finally {
                    ColumnStructureUpdatesGridExample.this.rowObjectsGlazedList.getReadWriteLock().writeLock().unlock();
                }
            }
        });
        return natTable;
    }

    @Override
    public String getDescription() {
        return "Column structure updates";
    }

    private Map<String, String> populateColHeaderPropertiesToLabelsMap() {
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        ColumnHeaders[] columnHeaders = ColumnHeaders.values();
        int i = 0;
        while (i < columnHeaders.length) {
            propertyToLabelMap.put(columnHeaders[i].getProperty(), columnHeaders[i].getLabel());
            ++i;
        }
        return propertyToLabelMap;
    }
}

