/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.ExtendedPersonWithAddress;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.DarkGroupByThemeExtension;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.DefaultGroupByThemeExtension;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigLabelModifier;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.ModernGroupByThemeExtension;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.IGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.SummationGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultSummaryRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.DarkNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.DefaultNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryDisplayConverter;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommand;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeLayerExpandCollapseKeyBindings;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.AbstractHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemState;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class _809_GroupBySummarySummaryRowExample
extends AbstractNatExample {
    private static final String ROW_HEADER_SUMMARY_ROW = "rowHeaderSummaryRowLabel";
    private IGroupBySummaryProvider<ExtendedPersonWithAddress> sumMoneyGroupBySummaryProvider;
    private IGroupBySummaryProvider<ExtendedPersonWithAddress> avgMoneyGroupBySummaryProvider;
    private ISummaryProvider sumMoneySummaryProvider;
    private ISummaryProvider avgMoneySummaryProvider;
    private boolean useMoneySum = true;
    private int currentTheme = 1;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(800, 600, new _809_GroupBySummarySummaryRowExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the group by feature in conjunction with summary values of the groupings.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        final ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"firstName", "lastName", "age", "money", "married", "gender", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("birthday", "Birthday");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        List persons = PersonService.getExtendedPersonsWithAddress((int)10000);
        final BodyLayerStack bodyLayerStack = new BodyLayerStack(persons, columnPropertyAccessor, configRegistry);
        bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(bodyLayerStack.getSortedList(), (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer), false);
        bodyLayerStack.getBodyDataLayer().initializeTreeComparator(sortHeaderLayer.getSortModel(), (IUniqueIndexLayer)bodyLayerStack.getTreeLayer(), true);
        DefaultSummaryRowHeaderDataProvider rowHeaderDataProvider = new DefaultSummaryRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider(), "\u2211");
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AbstractOverrider((DataLayer)rowHeaderDataLayer){
            private final /* synthetic */ DataLayer val$rowHeaderDataLayer;
            {
                this.val$rowHeaderDataLayer = dataLayer;
            }

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                if (rowPosition + 1 == this.val$rowHeaderDataLayer.getRowCount()) {
                    configLabels.addLabel(_809_GroupBySummarySummaryRowExample.ROW_HEADER_SUMMARY_ROW);
                    configLabels.addLabel("SummaryRow");
                }
            }
        });
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer, false);
        CompositeLayer compositeGridLayer = new CompositeLayer(1, 2);
        final GroupByHeaderLayer groupByHeaderLayer = new GroupByHeaderLayer(bodyLayerStack.getGroupByModel(), (ILayer)gridLayer, (IDataProvider)columnHeaderDataProvider);
        compositeGridLayer.setChildLayer("GROUP_BY_REGION", (ILayer)groupByHeaderLayer, 0, 0);
        compositeGridLayer.setChildLayer("Grid", (ILayer)gridLayer, 0, 1);
        final NatTable natTable = new NatTable(container, (ILayer)compositeGridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "COLUMN_4");
                Style style = new Style();
                style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.RIGHT);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", "COLUMN_2");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", "COLUMN_3");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", "COLUMN_3");
                style = new Style();
                style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.CENTER);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", _809_GroupBySummarySummaryRowExample.ROW_HEADER_SUMMARY_ROW);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "SELECT", _809_GroupBySummarySummaryRowExample.ROW_HEADER_SUMMARY_ROW);
            }
        });
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.sumMoneyGroupBySummaryProvider = new SummationGroupBySummaryProvider((IColumnAccessor)columnPropertyAccessor);
        this.avgMoneyGroupBySummaryProvider = new AverageMoneyGroupBySummaryProvider();
        ListDataProvider summaryDataProvider = new ListDataProvider(bodyLayerStack.getSortedList(), (IColumnAccessor)columnPropertyAccessor);
        this.sumMoneySummaryProvider = new SummationSummaryProvider((IDataProvider)summaryDataProvider, false);
        this.avgMoneySummaryProvider = new AverageMoneySummaryProvider((IDataProvider)summaryDataProvider);
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration((IDataProvider)summaryDataProvider){
            private final /* synthetic */ IDataProvider val$summaryDataProvider;
            {
                this.val$summaryDataProvider = iDataProvider;
            }

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_809_GroupBySummarySummaryRowExample.this.sumMoneyGroupBySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)new AverageAgeGroupBySummaryProvider(), "NORMAL", "GROUP_BY_COLUMN_2");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_CHILD_COUNT_PATTERN, (Object)"[{0}] - ({1})");
                configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)_809_GroupBySummarySummaryRowExample.this.sumMoneySummaryProvider, "NORMAL", "SummaryColumn_3");
                configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageAgeSummaryProvider(this.val$summaryDataProvider), "NORMAL", "SummaryColumn_2");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new SummaryDisplayConverter((IDisplayConverter)new DefaultDoubleDisplayConverter()), "NORMAL", "SummaryColumn_3");
            }
        });
        natTable.addConfiguration((IConfiguration)new GroupByHeaderMenuConfiguration(natTable, groupByHeaderLayer));
        natTable.addConfiguration((IConfiguration)new AbstractHeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withHideColumnMenuItem().withShowAllColumnsMenuItem().withStateManagerMenuItemProvider();
            }

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withShowAllColumnsMenuItem().withStateManagerMenuItemProvider();
            }
        });
        natTable.addConfiguration((IConfiguration)new TreeLayerExpandCollapseKeyBindings(bodyLayerStack.getTreeLayer(), bodyLayerStack.getSelectionLayer()));
        natTable.addConfiguration((IConfiguration)new TreeDebugMenuConfiguration(natTable));
        natTable.configure();
        DefaultNatTableThemeConfiguration defaultTheme = new DefaultNatTableThemeConfiguration();
        defaultTheme.addThemeExtension((IThemeExtension)new DefaultGroupByThemeExtension());
        ModernNatTableThemeConfiguration modernTheme = new ModernNatTableThemeConfiguration();
        modernTheme.addThemeExtension((IThemeExtension)new ModernGroupByThemeExtension());
        DarkNatTableThemeConfiguration darkTheme = new DarkNatTableThemeConfiguration();
        darkTheme.addThemeExtension((IThemeExtension)new DarkGroupByThemeExtension());
        natTable.setTheme((ThemeConfiguration)modernTheme);
        natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        Button toggleHeaderButton = new Button(buttonPanel, 8);
        toggleHeaderButton.setText("Toggle Group By Header");
        toggleHeaderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                groupByHeaderLayer.setVisible(!groupByHeaderLayer.isVisible());
            }
        });
        Button collapseAllButton = new Button(buttonPanel, 8);
        collapseAllButton.setText("Collapse All");
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            }
        });
        Button expandAllButton = new Button(buttonPanel, 8);
        expandAllButton.setText("Expand All");
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
            }
        });
        Button toggleMoneySummaryButton = new Button(buttonPanel, 8);
        toggleMoneySummaryButton.setText("Toggle Money Group Summary (SUM/AVG)");
        toggleMoneySummaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bodyLayerStack.getBodyDataLayer().clearCache();
                _809_GroupBySummarySummaryRowExample.this.useMoneySum = !_809_GroupBySummarySummaryRowExample.this.useMoneySum;
                if (_809_GroupBySummarySummaryRowExample.this.useMoneySum) {
                    configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_809_GroupBySummarySummaryRowExample.this.sumMoneyGroupBySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                    configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)_809_GroupBySummarySummaryRowExample.this.sumMoneySummaryProvider, "NORMAL", "SummaryColumn_3");
                } else {
                    configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_809_GroupBySummarySummaryRowExample.this.avgMoneyGroupBySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                    configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)_809_GroupBySummarySummaryRowExample.this.avgMoneySummaryProvider, "NORMAL", "SummaryColumn_3");
                }
                natTable.doCommand((ILayerCommand)new VisualRefreshCommand());
            }
        });
        Button toggleThemeButton = new Button(buttonPanel, 8);
        toggleThemeButton.setText("Toggle Theme");
        toggleThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)modernTheme, (ThemeConfiguration)darkTheme, (ThemeConfiguration)defaultTheme){
            private final /* synthetic */ ThemeConfiguration val$modernTheme;
            private final /* synthetic */ ThemeConfiguration val$darkTheme;
            private final /* synthetic */ ThemeConfiguration val$defaultTheme;
            {
                this.val$modernTheme = themeConfiguration;
                this.val$darkTheme = themeConfiguration2;
                this.val$defaultTheme = themeConfiguration3;
            }

            public void widgetSelected(SelectionEvent e) {
                if (_809_GroupBySummarySummaryRowExample.this.currentTheme == 0) {
                    natTable.setTheme(this.val$modernTheme);
                    _809_GroupBySummarySummaryRowExample _809_GroupBySummarySummaryRowExample2 = _809_GroupBySummarySummaryRowExample.this;
                    _809_GroupBySummarySummaryRowExample2.currentTheme = _809_GroupBySummarySummaryRowExample2.currentTheme + 1;
                } else if (_809_GroupBySummarySummaryRowExample.this.currentTheme == 1) {
                    natTable.setTheme(this.val$darkTheme);
                    _809_GroupBySummarySummaryRowExample _809_GroupBySummarySummaryRowExample3 = _809_GroupBySummarySummaryRowExample.this;
                    _809_GroupBySummarySummaryRowExample3.currentTheme = _809_GroupBySummarySummaryRowExample3.currentTheme + 1;
                } else if (_809_GroupBySummarySummaryRowExample.this.currentTheme == 2) {
                    natTable.setTheme(this.val$defaultTheme);
                    _809_GroupBySummarySummaryRowExample.this.currentTheme = 0;
                }
            }
        });
        Button button = new Button(buttonPanel, 8);
        button.setText("Add Row");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bodyLayerStack.getSortedList().add((Object)PersonService.createExtendedPersonWithAddress((int)bodyLayerStack.getSortedList().size()));
            }
        });
        Button change = new Button(buttonPanel, 8);
        change.setText("Change Content");
        change.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bodyLayerStack.getSortedList().getReadWriteLock().writeLock().lock();
                try {
                    bodyLayerStack.getGlazedListsEventLayer().deactivate();
                    bodyLayerStack.getSortedList().clear();
                    bodyLayerStack.getSortedList().addAll((Collection)PersonService.getExtendedPersonsWithAddress((int)1000));
                }
                finally {
                    bodyLayerStack.getSortedList().getReadWriteLock().writeLock().unlock();
                    bodyLayerStack.getGlazedListsEventLayer().activate();
                }
            }
        });
        return container;
    }

    class AverageAgeGroupBySummaryProvider
    implements IGroupBySummaryProvider<ExtendedPersonWithAddress> {
        AverageAgeGroupBySummaryProvider() {
        }

        public Object summarize(int columnIndex, List<ExtendedPersonWithAddress> children) {
            int summaryValue = 0;
            for (ExtendedPersonWithAddress child : children) {
                summaryValue += child.getAge();
            }
            return summaryValue / (children.size() > 0 ? children.size() : 1);
        }
    }

    class AverageAgeSummaryProvider
    implements ISummaryProvider {
        private IDataProvider dataProvider;

        public AverageAgeSummaryProvider(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
        }

        public Object summarize(int columnIndex) {
            double total = 0.0;
            int rowCount = this.dataProvider.getRowCount();
            int valueRows = 0;
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                Object dataValue = this.dataProvider.getDataValue(columnIndex, rowIndex);
                if (dataValue instanceof Number) {
                    total += Double.parseDouble(dataValue.toString());
                    ++valueRows;
                }
                ++rowIndex;
            }
            return "Avg: " + String.format("%.2f", total / (double)valueRows);
        }
    }

    class AverageMoneyGroupBySummaryProvider
    implements IGroupBySummaryProvider<ExtendedPersonWithAddress> {
        AverageMoneyGroupBySummaryProvider() {
        }

        public Object summarize(int columnIndex, List<ExtendedPersonWithAddress> children) {
            double summaryValue = 0.0;
            for (ExtendedPersonWithAddress child : children) {
                summaryValue += child.getMoney().doubleValue();
            }
            NumberFormat format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(2);
            return format.format(summaryValue / (double)(children.size() > 0 ? children.size() : 1));
        }
    }

    class AverageMoneySummaryProvider
    implements ISummaryProvider {
        private IDataProvider dataProvider;

        public AverageMoneySummaryProvider(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
        }

        public Object summarize(int columnIndex) {
            double total = 0.0;
            int rowCount = this.dataProvider.getRowCount();
            int valueRows = 0;
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                Object dataValue = this.dataProvider.getDataValue(columnIndex, rowIndex);
                if (dataValue instanceof Number) {
                    total += Double.parseDouble(dataValue.toString());
                    ++valueRows;
                }
                ++rowIndex;
            }
            return "Avg: " + String.format("%.2f", total / (double)valueRows);
        }
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final SortedList<T> sortedList;
        private final IDataProvider bodyDataProvider;
        private final GroupByDataLayer<T> bodyDataLayer;
        private final GlazedListsEventLayer<T> glazedListsEventLayer;
        private final SelectionLayer selectionLayer;
        private final TreeLayer treeLayer;
        private final GroupByModel groupByModel = new GroupByModel();

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor, ConfigRegistry configRegistry) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            this.sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.bodyDataLayer = new GroupByDataLayer(this.getGroupByModel(), this.sortedList, columnPropertyAccessor, (IConfigRegistry)configRegistry);
            this.bodyDataProvider = this.bodyDataLayer.getDataProvider();
            this.glazedListsEventLayer = new GlazedListsEventLayer(this.bodyDataLayer, this.sortedList);
            this.glazedListsEventLayer.addLayerListener(new ILayerListener(){

                public void handleLayerEvent(ILayerEvent event) {
                    if (event instanceof IVisualChangeEvent) {
                        BodyLayerStack.this.bodyDataLayer.clearCache();
                    }
                }
            });
            SummaryRowLayer summaryRowLayer = new SummaryRowLayer(this.glazedListsEventLayer, (IConfigRegistry)configRegistry, false);
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)summaryRowLayer);
            ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
            this.treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)this.bodyDataLayer.getTreeRowModel());
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.treeLayer);
            viewportLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new GroupByConfigLabelModifier(this.getGroupByModel()));
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public TreeLayer getTreeLayer() {
            return this.treeLayer;
        }

        public SortedList<T> getSortedList() {
            return this.sortedList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public GroupByDataLayer<T> getBodyDataLayer() {
            return this.bodyDataLayer;
        }

        public GlazedListsEventLayer<T> getGlazedListsEventLayer() {
            return this.glazedListsEventLayer;
        }

        public GroupByModel getGroupByModel() {
            return this.groupByModel;
        }
    }

    class TreeDebugMenuConfiguration
    extends AbstractUiBindingConfiguration {
        private final Menu menu;

        public TreeDebugMenuConfiguration(final NatTable natTable) {
            this.menu = new PopupMenuBuilder(natTable).withMenuItemProvider("expandToLevel", new IMenuItemProvider(){

                public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                    MenuItem menuItem = new MenuItem(popupMenu, 8);
                    menuItem.setText("Expand 2 level");
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            NatEventData eventData = MenuItemProviders.getNatEventData((SelectionEvent)event);
                            int rowIndex = natTable.getRowIndexByPosition(eventData.getRowPosition());
                            natTable.doCommand((ILayerCommand)new TreeExpandToLevelCommand(Integer.valueOf(rowIndex), 2));
                        }
                    });
                }
            }).withVisibleState("expandToLevel", new IMenuItemState(){

                public boolean isActive(NatEventData natEventData) {
                    ILayerCell cell = natTable.getCellByPosition(natEventData.getColumnPosition(), natEventData.getRowPosition());
                    return cell.getConfigLabels().hasLabel("TREE_COLUMN_CELL");
                }
            }).withInspectLabelsMenuItem().build();
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3), (IMouseAction)new PopupMenuAction(this.menu));
        }
    }
}

