/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowTextCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupExpandCollapseLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupReorderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class _807_SortableFilterableColumnGroupExample
extends AbstractNatExample {
    private final ColumnGroupModel columnGroupModel = new ColumnGroupModel();
    private final ColumnGroupModel sndColumnGroupModel = new ColumnGroupModel();

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _807_SortableFilterableColumnGroupExample());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "address.street", "address.housenumber", "address.postalCode", "address.city", "age", "birthday", "money", "description", "favouriteFood", "favouriteDrinks"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("address.street", "Street");
        propertyToLabelMap.put("address.housenumber", "Housenumber");
        propertyToLabelMap.put("address.postalCode", "Postalcode");
        propertyToLabelMap.put("address.city", "City");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("birthday", "Birthday");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("description", "Description");
        propertyToLabelMap.put("favouriteFood", "Food");
        propertyToLabelMap.put("favouriteDrinks", "Drinks");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        BodyLayerStack bodyLayer = new BodyLayerStack(PersonService.getExtendedPersonsWithAddress((int)10), columnPropertyAccessor, new ColumnGroupModel[]{this.sndColumnGroupModel, this.columnGroupModel});
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DataLayer columnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayer, bodyLayer.getSelectionLayer());
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(bodyLayer.getSortedList(), (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer));
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)sortHeaderLayer, bodyLayer.getSelectionLayer(), this.columnGroupModel);
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Person", new int[]{0, 1, 2, 3});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Address", new int[]{4, 5, 6, 7});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Facts", new int[]{8, 9, 10});
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Personal", new int[]{11, 12, 13});
        columnGroupHeaderLayer.setStaticColumnIndexesByGroup("Person", new int[]{0, 1});
        columnGroupHeaderLayer.setStaticColumnIndexesByGroup("Address", new int[]{4, 5, 6});
        ColumnGroupGroupHeaderLayer sndGroup = new ColumnGroupGroupHeaderLayer(columnGroupHeaderLayer, bodyLayer.getSelectionLayer(), this.sndColumnGroupModel);
        sndGroup.addColumnsIndexesToGroup("PersonWithAddress", new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        sndGroup.addColumnsIndexesToGroup("Additional Information", new int[]{8, 9, 10, 11, 12, 13});
        sndGroup.setStaticColumnIndexesByGroup("PersonWithAddress", new int[]{0, 1});
        FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(bodyLayer.getFilterList(), (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry), (ILayer)sndGroup, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)configRegistry);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayer.getBodyDataProvider());
        DataLayer rowHeaderDataLayer = new DataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setDefaultColumnWidth(40);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayer, bodyLayer.getSelectionLayer());
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayer, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new FilterRowConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withColumnChooserMenuItem();
            }
        });
        final Menu columnGroupHeaderMenu = new PopupMenuBuilder(natTable).withRenameColumnGroupMenuItem().withRemoveColumnGroupMenuItem().build();
        natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerFirstMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "COLUMN_GROUP_HEADER", 3), (IMouseAction)new PopupMenuAction(columnGroupHeaderMenu));
            }
        });
        DisplayColumnChooserCommandHandler columnChooserCommandHandler = new DisplayColumnChooserCommandHandler(bodyLayer.getSelectionLayer(), bodyLayer.getColumnHideShowLayer(), columnHeaderLayer, columnHeaderDataLayer, columnGroupHeaderLayer, this.columnGroupModel);
        bodyLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
        natTable.configure();
        return natTable;
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final SortedList<T> sortedList;
        private final FilterList<T> filterList;
        private final IDataProvider bodyDataProvider;
        private ColumnReorderLayer columnReorderLayer;
        private ColumnGroupReorderLayer columnGroupReorderLayer;
        private ColumnHideShowLayer columnHideShowLayer;
        private ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer;
        private SelectionLayer selectionLayer;
        private ViewportLayer viewportLayer;

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor, ColumnGroupModel ... columnGroupModel) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            this.sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.filterList = new FilterList(this.getSortedList());
            this.bodyDataProvider = new ListDataProvider(this.filterList, columnPropertyAccessor);
            DataLayer bodyDataLayer = new DataLayer(this.bodyDataProvider);
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.filterList);
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)glazedListsEventLayer);
            this.columnGroupReorderLayer = new ColumnGroupReorderLayer((IUniqueIndexLayer)this.columnReorderLayer, columnGroupModel[columnGroupModel.length - 1]);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnGroupReorderLayer);
            this.columnGroupExpandCollapseLayer = new ColumnGroupExpandCollapseLayer((IUniqueIndexLayer)this.columnHideShowLayer, columnGroupModel);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnGroupExpandCollapseLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            FreezeLayer freezeLayer = new FreezeLayer((IUniqueIndexLayer)this.selectionLayer);
            CompositeFreezeLayer compositeFreezeLayer = new CompositeFreezeLayer(freezeLayer, this.viewportLayer, this.selectionLayer);
            this.setUnderlyingLayer((ILayer)compositeFreezeLayer);
        }

        public SortedList<T> getSortedList() {
            return this.sortedList;
        }

        public FilterList<T> getFilterList() {
            return this.filterList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public ColumnReorderLayer getColumnReorderLayer() {
            return this.columnReorderLayer;
        }

        public ColumnGroupReorderLayer getColumnGroupReorderLayer() {
            return this.columnGroupReorderLayer;
        }

        public ColumnHideShowLayer getColumnHideShowLayer() {
            return this.columnHideShowLayer;
        }

        public ColumnGroupExpandCollapseLayer getColumnGroupExpandCollapseLayer() {
            return this.columnGroupExpandCollapseLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public ViewportLayer getViewportLayer() {
            return this.viewportLayer;
        }
    }

    class FilterRowConfiguration
    extends AbstractRegistryConfiguration {
        FilterRowConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new FilterRowTextCellEditor(), "NORMAL", "FILTER_COLUMN_0");
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(Person.Gender.FEMALE, Person.Gender.MALE));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "NORMAL", "FILTER_COLUMN_2");
            comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(Boolean.TRUE, Boolean.FALSE));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "NORMAL", "FILTER_COLUMN_3");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.EXACT, "NORMAL", "FILTER_COLUMN_2");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, (Object)"&");
        }
    }
}

