/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._700_AdditionalFunctions;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.IExportFormatter;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.NatExporter;
import org.eclipse.nebula.widgets.nattable.extension.poi.HSSFExcelExporter;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class _774_MultiExportExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 480, new _774_MultiExportExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to trigger an export for multiple NatTable instances.\nBy pressing the button the two NatTable instances will be exported into one Excel with two sheets.\nThis example does not add any further export configuration.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        GridLayer grid = this.createGrid(propertyNames, propertyToLabelMap, PersonService.getPersons((int)5));
        final NatTable natTable = new NatTable(gridPanel, (ILayer)grid, false);
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator(grid.getBodyLayer());
        ((AbstractLayer)grid.getBodyLayer()).setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                Style style = new Style();
                style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
                style.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignmentEnum.TOP);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_ONE_LABEL);
                style = new Style();
                style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.RIGHT);
                style.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)VerticalAlignmentEnum.BOTTOM);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", COLUMN_TWO_LABEL);
            }
        });
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)new HSSFExcelExporter());
                configRegistry.registerConfigAttribute(ExportConfigAttributes.DATE_FORMAT, (Object)"dd.MM.yyyy");
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, (Object)new ExampleExportFormatter(), "NORMAL", "BODY");
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, (Object)new IExportFormatter(){

                    public Object formatForExport(ILayerCell cell, IConfigRegistry configRegistry) {
                        return cell.getDataValue();
                    }
                }, "NORMAL", "ROW_HEADER");
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        String[] numberPropertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        HashMap<String, String> numberPropertyToLabelMap = new HashMap<String, String>();
        numberPropertyToLabelMap.put("columnOneNumber", "Value One");
        numberPropertyToLabelMap.put("columnTwoNumber", "Value Two");
        numberPropertyToLabelMap.put("columnThreeNumber", "Value Three");
        numberPropertyToLabelMap.put("columnFourNumber", "Value Four");
        numberPropertyToLabelMap.put("columnFiveNumber", "Value Five");
        ArrayList<NumberValues> valuesToShow = new ArrayList<NumberValues>();
        valuesToShow.add(this.createNumberValues());
        valuesToShow.add(this.createNumberValues());
        valuesToShow.add(this.createNumberValues());
        valuesToShow.add(this.createNumberValues());
        valuesToShow.add(this.createNumberValues());
        final NatTable numberNatTable = new NatTable(gridPanel, (ILayer)this.createGrid(numberPropertyNames, numberPropertyToLabelMap, valuesToShow), false);
        numberNatTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        numberNatTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, (Object)new IExportFormatter(){

                    public Object formatForExport(ILayerCell cell, IConfigRegistry configRegistry) {
                        return cell.getDataValue();
                    }
                }, "NORMAL", "BODY");
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, (Object)new IExportFormatter(){

                    public Object formatForExport(ILayerCell cell, IConfigRegistry configRegistry) {
                        return cell.getDataValue();
                    }
                }, "NORMAL", "ROW_HEADER");
            }
        });
        numberNatTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)numberNatTable);
        Button addColumnButton = new Button(buttonPanel, 8);
        addColumnButton.setText("Export");
        addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap<String, NatTable> export = new HashMap<String, NatTable>();
                export.put("Persons", natTable);
                export.put("Numbers", numberNatTable);
                new NatExporter(Display.getCurrent().getActiveShell()).exportMultipleNatTables((ILayerExporter)new HSSFExcelExporter(), export);
            }
        });
        return panel;
    }

    private <T> GridLayer createGrid(String[] propertyNames, Map<String, String> propertyToLabelMap, List<T> values) {
        DefaultBodyDataProvider bodyDataProvider = new DefaultBodyDataProvider(values, propertyNames);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        return new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
    }

    private NumberValues createNumberValues() {
        NumberValues nv = new NumberValues();
        nv.setColumnOneNumber(10);
        nv.setColumnTwoNumber(20);
        nv.setColumnThreeNumber(30);
        nv.setColumnFourNumber(40);
        nv.setColumnFiveNumber(50);
        return nv;
    }

    class ExampleExportFormatter
    implements IExportFormatter {
        ExampleExportFormatter() {
        }

        public Object formatForExport(ILayerCell cell, IConfigRegistry configRegistry) {
            Object data = cell.getDataValue();
            if (data != null) {
                try {
                    if (data instanceof Boolean) {
                        return (Boolean)data != false ? "X" : "";
                    }
                    if (data instanceof Date) {
                        return data;
                    }
                    return data.toString();
                }
                catch (Exception exception) {
                    return data.toString();
                }
            }
            return "";
        }
    }
}

