/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._506_Hover;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.hover.HoverLayer;
import org.eclipse.nebula.widgets.nattable.hover.config.ColumnHeaderHoverLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _5062_CompositeHoverStylingExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5062_CompositeHoverStylingExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the HoverLayer within a layer composition that consists of a column header and a body.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        DefaultBodyDataProvider bodyDataProvider = new DefaultBodyDataProvider(PersonService.getPersons((int)10), propertyNames);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        HoverLayer hoverLayer = new HoverLayer((IUniqueIndexLayer)bodyDataLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)hoverLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        HoverLayer columnHoverLayer = new HoverLayer((IUniqueIndexLayer)columnHeaderDataLayer, false);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHoverLayer, (ILayer)viewportLayer, selectionLayer, false);
        columnHeaderLayer.addConfiguration((IConfiguration)new ColumnHeaderHoverLayerConfiguration(columnHoverLayer));
        CompositeLayer compLayer = new CompositeLayer(1, 2);
        compLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                Style style = new Style();
                style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.getColor((int)217, (int)232, (int)251));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "HOVER");
                Image bgImage = GUIHelper.getImageByURL((String)"columnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/column_header_bg.png"));
                Image hoverBgImage = GUIHelper.getImageByURL((String)"hoverColumnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/hovered_column_header_bg.png"));
                TextPainter txtPainter = new TextPainter(false, false);
                BackgroundImagePainter bgImagePainter = new BackgroundImagePainter((ICellPainter)txtPainter, bgImage, GUIHelper.getColor((int)192, (int)192, (int)192));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)bgImagePainter, "NORMAL", "COLUMN_HEADER");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)bgImagePainter, "NORMAL", "CORNER");
                BackgroundImagePainter hoveredHeaderPainter = new BackgroundImagePainter((ICellPainter)txtPainter, hoverBgImage, GUIHelper.getColor((int)192, (int)192, (int)192));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)hoveredHeaderPainter, "HOVER", "COLUMN_HEADER");
            }
        });
        natTable.configure();
        return natTable;
    }
}

