/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._501_Data;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyModifiableBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _5013_PercentageSizingGridExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 850, new _5013_PercentageSizingGridExample());
    }

    @Override
    public String getDescription() {
        return "This example shows some examples for NatTable grid compositions that are using percentage sizing.\n\nFirst table:\tAll columns and all rows have the same size by calculating the size dependent on the available width\nSecond table:\tAll columns have fixed percentage values (25% / 25% / 50%)\nThird table:\tColumn 1 and 3 are configured to take 40% of the available space each, column 2 will take the rest\nFourth table:\tColumn 1 and 2 are configured for 100 pixels width, column 3 will take the rest";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        final DummyModifiableBodyDataProvider dataProvider = new DummyModifiableBodyDataProvider(3, 2);
        SimpleGridLayer gridLayer = new SimpleGridLayer((IDataProvider)dataProvider);
        final DataLayer n4DataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        n4DataLayer.setColumnPercentageSizing(true);
        n4DataLayer.setRowPercentageSizing(true);
        final NatTable n4 = new NatTable(gridPanel, 538181632, (ILayer)gridLayer, false);
        n4.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        n4.addConfiguration((IConfiguration)new HeaderMenuConfiguration(n4));
        n4.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)n4);
        gridLayer = new SimpleGridLayer((IDataProvider)dataProvider);
        final DataLayer n5DataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        n5DataLayer.setColumnWidthByPosition(0, 25);
        n5DataLayer.setColumnWidthByPosition(1, 25);
        n5DataLayer.setColumnWidthByPosition(2, 50);
        n5DataLayer.setColumnPercentageSizing(true);
        final NatTable n5 = new NatTable(gridPanel, 538181632, (ILayer)gridLayer, false);
        n5.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        n5.addConfiguration((IConfiguration)new HeaderMenuConfiguration(n5));
        n5.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)n5);
        gridLayer = new SimpleGridLayer((IDataProvider)dataProvider);
        final DataLayer n6DataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        n6DataLayer.setColumnWidthByPosition(0, 20);
        n6DataLayer.setColumnWidthByPosition(2, 20);
        n6DataLayer.setColumnPercentageSizing(true);
        final NatTable n6 = new NatTable(gridPanel, 538181632, (ILayer)gridLayer, false);
        n6.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        n6.addConfiguration((IConfiguration)new HeaderMenuConfiguration(n6));
        n6.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)n6);
        gridLayer = new SimpleGridLayer((IDataProvider)dataProvider);
        final DataLayer mixGridDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        mixGridDataLayer.setColumnPercentageSizing(true);
        mixGridDataLayer.setColumnPercentageSizing(0, false);
        mixGridDataLayer.setColumnPercentageSizing(1, false);
        mixGridDataLayer.setColumnWidthByPosition(0, 100);
        mixGridDataLayer.setColumnWidthByPosition(1, 100);
        final NatTable mixGrid = new NatTable(gridPanel, 538181632, (ILayer)gridLayer, false);
        mixGrid.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        mixGrid.addConfiguration((IConfiguration)new HeaderMenuConfiguration(mixGrid));
        mixGrid.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mixGrid);
        Button addColumnButton = new Button(buttonPanel, 8);
        addColumnButton.setText("add column - no width");
        addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dataProvider.setColumnCount(dataProvider.getColumnCount() + 1);
                n4.refresh();
                n5.refresh();
                n6.refresh();
                mixGrid.refresh();
            }
        });
        Button addColumnButton2 = new Button(buttonPanel, 8);
        addColumnButton2.setText("add column - 20 percent width");
        addColumnButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dataProvider.setColumnCount(dataProvider.getColumnCount() + 1);
                n4DataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                n5DataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                n6DataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                mixGridDataLayer.setColumnWidthPercentageByPosition(dataProvider.getColumnCount() - 1, 20);
                n4.refresh();
                n5.refresh();
                n6.refresh();
                mixGrid.refresh();
            }
        });
        return panel;
    }

    class SimpleGridLayer
    extends GridLayer {
        IDataProvider bodyDataProvider;
        DataLayer bodyDataLayer;
        SelectionLayer selectionLayer;

        protected SimpleGridLayer(IDataProvider bodyDataProvider) {
            super(true);
            this.bodyDataProvider = bodyDataProvider;
            this.bodyDataLayer = new DataLayer(bodyDataProvider);
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer);
            ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
            this.setBodyLayer((ILayer)this.selectionLayer);
            DummyColumnHeaderDataProvider columnHeaderDataProvider = new DummyColumnHeaderDataProvider(bodyDataProvider);
            DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)this.selectionLayer, this.selectionLayer);
            this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
            DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyDataProvider);
            DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.selectionLayer, this.selectionLayer);
            this.setRowHeaderLayer((ILayer)rowHeaderLayer);
            DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
            DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.setCornerLayer((ILayer)cornerLayer);
        }

        public IUniqueIndexLayer getBodyDataLayer() {
            return this.bodyDataLayer;
        }
    }
}

