/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.AbstractRowCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowDeleteEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class _308_DataModificationExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 650, new _308_DataModificationExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to add and remove data values at runtime. Via right-click on a cell it is possible to insert a new row object below the current selected row or to delete the current selected row.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        String[] personPropertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> personPropertyToLabelMap = new HashMap<String, String>();
        personPropertyToLabelMap.put("firstName", "Firstname");
        personPropertyToLabelMap.put("lastName", "Lastname");
        personPropertyToLabelMap.put("gender", "Gender");
        personPropertyToLabelMap.put("married", "Married");
        personPropertyToLabelMap.put("birthday", "Birthday");
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersons((int)10), (IColumnAccessor)new ReflectiveColumnPropertyAccessor(personPropertyNames));
        DefaultColumnHeaderDataProvider personColumnHeaderDataProvider = new DefaultColumnHeaderDataProvider(personPropertyNames, personPropertyToLabelMap);
        DefaultRowHeaderDataProvider personRowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        HashMap<String, String> addressPropertyToLabelMap = new HashMap<String, String>();
        addressPropertyToLabelMap.put("street", "Street");
        addressPropertyToLabelMap.put("housenumber", "Housenumber");
        addressPropertyToLabelMap.put("postalCode", "Postal Code");
        addressPropertyToLabelMap.put("city", "City");
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonPanel);
        ConfigRegistry configRegistry = new ConfigRegistry();
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        bodyDataLayer.setConfigLabelAccumulator(new IConfigLabelAccumulator(){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                switch (columnPosition) {
                    case 3: {
                        configLabels.addLabel("MARRIED");
                        break;
                    }
                    case 4: {
                        configLabels.addLabel("DATE");
                    }
                }
            }
        });
        final DefaultBodyLayerStack bodyLayerStack = new DefaultBodyLayerStack((IUniqueIndexLayer)bodyDataLayer);
        bodyDataLayer.registerCommandHandler(new DeleteRowCommandHandler(bodyDataProvider.getList()));
        bodyDataLayer.registerCommandHandler(new InsertRowCommandHandler(bodyDataProvider.getList()));
        DataLayer columnHeaderDataLayer = new DataLayer((IDataProvider)personColumnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)personRowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer());
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)personColumnHeaderDataProvider, (IDataProvider)personRowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "MARRIED");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter("yyyy-MM-dd"), "NORMAL", "DATE");
            }
        });
        natTable.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(natTable, bodyDataLayer){
            private final Menu bodyMenu;
            {
                this.bodyMenu = new PopupMenuBuilder(natTable).withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                        MenuItem deleteRow = new MenuItem(popupMenu, 8);
                        deleteRow.setText("Insert below");
                        deleteRow.setEnabled(true);
                        deleteRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                int rowPosition = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition();
                                natTable.doCommand(new InsertRowCommand<Person>((ILayer)dataLayer, rowPosition, (Person)PersonService.getPersons((int)1).get(0)));
                            }
                        });
                    }
                }).withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                        MenuItem deleteRow = new MenuItem(popupMenu, 8);
                        deleteRow.setText("Delete");
                        deleteRow.setEnabled(true);
                        deleteRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                int rowPosition = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition();
                                natTable.doCommand((ILayerCommand)new DeleteRowCommand((ILayer)natTable, rowPosition));
                            }
                        });
                    }
                }).build();
            }

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "BODY", 3), (IMouseAction)new PopupMenuAction(this.bodyMenu){

                    public void run(NatTable natTable, MouseEvent event) {
                        int columnPosition = natTable.getColumnPositionByX(event.x);
                        int rowPosition = natTable.getRowPositionByY(event.y);
                        if (!bodyLayerStack.getSelectionLayer().isRowPositionFullySelected(rowPosition)) {
                            natTable.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)natTable, columnPosition, rowPosition, false, false));
                        }
                        super.run(natTable, event);
                    }
                });
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        return panel;
    }

    class DeleteRowCommand
    extends AbstractRowCommand {
        public DeleteRowCommand(ILayer layer, int rowPosition) {
            super(layer, rowPosition);
        }

        protected DeleteRowCommand(DeleteRowCommand command) {
            super((AbstractRowCommand)command);
        }

        public ILayerCommand cloneCommand() {
            return new DeleteRowCommand(this);
        }
    }

    class DeleteRowCommandHandler<T>
    implements ILayerCommandHandler<DeleteRowCommand> {
        private List<T> bodyData;

        public DeleteRowCommandHandler(List<T> bodyData) {
            this.bodyData = bodyData;
        }

        public Class<DeleteRowCommand> getCommandClass() {
            return DeleteRowCommand.class;
        }

        public boolean doCommand(ILayer targetLayer, DeleteRowCommand command) {
            if (command.convertToTargetLayer(targetLayer)) {
                this.bodyData.remove(command.getRowPosition());
                targetLayer.fireLayerEvent((ILayerEvent)new RowDeleteEvent(targetLayer, command.getRowPosition()));
                return true;
            }
            return false;
        }
    }

    class InsertRowCommand<T>
    extends AbstractRowCommand {
        private final T object;

        public InsertRowCommand(ILayer layer, int rowPosition, T object) {
            super(layer, rowPosition);
            this.object = object;
        }

        protected InsertRowCommand(InsertRowCommand<T> command) {
            super(command);
            this.object = command.object;
        }

        public ILayerCommand cloneCommand() {
            return new InsertRowCommand<T>(this);
        }

        public T getObject() {
            return this.object;
        }
    }

    class InsertRowCommandHandler<T>
    implements ILayerCommandHandler<InsertRowCommand> {
        private List<T> bodyData;

        public InsertRowCommandHandler(List<T> bodyData) {
            this.bodyData = bodyData;
        }

        public Class<InsertRowCommand> getCommandClass() {
            return InsertRowCommand.class;
        }

        public boolean doCommand(ILayer targetLayer, InsertRowCommand command) {
            if (command.convertToTargetLayer(targetLayer)) {
                this.bodyData.add(command.getRowPosition(), command.getObject());
                targetLayer.fireLayerEvent((ILayerEvent)new RowInsertEvent(targetLayer, command.getRowPosition()));
                return true;
            }
            return false;
        }
    }
}

