/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.poi.HSSFExcelExporter;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfiguration;
import org.eclipse.nebula.widgets.nattable.formula.FormulaDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.FormulaErrorReporter;
import org.eclipse.nebula.widgets.nattable.formula.FormulaTooltipErrorReporter;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.config.DefaultFormulaConfiguration;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultGridLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _305_FormulaDataExample
extends AbstractNatExample {
    boolean evaluationEnabled = true;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _305_FormulaDataExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates the usage of formulas to calculate cell values dynamically similar to spreadsheet applications.\nCurrently the following functions are supported: SUM, NEGATE, PRODUCT, QUOTIENT, MOD, POWER, SQRT and AVERAGE.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        ConfigRegistry configRegistry = new ConfigRegistry();
        FormulaGridLayer gridLayer = new FormulaGridLayer();
        final NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        final FormulaBodyLayerStack bodyLayer = gridLayer.getBodyLayer();
        natTable.addConfiguration((IConfiguration)new FillHandleConfiguration(bodyLayer.getSelectionLayer()));
        natTable.addConfiguration((IConfiguration)new DefaultFormulaConfiguration(bodyLayer.getFormulaDataProvider(), bodyLayer.getSelectionLayer(), natTable.getInternalCellClipboard()));
        bodyLayer.getFormulaDataProvider().setErrorReporter((FormulaErrorReporter)new FormulaTooltipErrorReporter(natTable, (IUniqueIndexLayer)bodyLayer.getDataLayer()));
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                HSSFExcelExporter exporter = new HSSFExcelExporter();
                exporter.setApplyBackgroundColor(false);
                exporter.setFormulaParser(bodyLayer.getFormulaDataProvider().getFormulaParser());
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)exporter);
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        final Button toggleFormulaButton = new Button(panel, 8);
        toggleFormulaButton.setText("Disable Formula Evaluation");
        toggleFormulaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bl = _305_FormulaDataExample.this.evaluationEnabled = !_305_FormulaDataExample.this.evaluationEnabled;
                if (_305_FormulaDataExample.this.evaluationEnabled) {
                    natTable.doCommand((ILayerCommand)new EnableFormulaEvaluationCommand());
                    toggleFormulaButton.setText("Disable Formula Evaluation");
                } else {
                    natTable.doCommand((ILayerCommand)new DisableFormulaEvaluationCommand());
                    toggleFormulaButton.setText("Enable Formula Evaluation");
                }
            }
        });
        return panel;
    }

    class FormulaBodyLayerStack
    extends AbstractLayerTransform {
        private final FormulaDataProvider formulaDataProvider;
        private final DataLayer bodyDataLayer;
        private final ColumnReorderLayer columnReorderLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;

        public FormulaBodyLayerStack() {
            TwoDimensionalArrayDataProvider dataProvider = new TwoDimensionalArrayDataProvider(new String[26][50]);
            this.formulaDataProvider = new FormulaDataProvider((IDataProvider)dataProvider);
            this.bodyDataLayer = new DataLayer((IDataProvider)this.formulaDataProvider);
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)this.viewportLayer);
        }

        public FormulaDataProvider getFormulaDataProvider() {
            return this.formulaDataProvider;
        }

        public DataLayer getDataLayer() {
            return this.bodyDataLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    class FormulaGridLayer
    extends GridLayer {
        public FormulaGridLayer() {
            super(false);
            this.addConfiguration((IConfiguration)new DefaultGridLayerConfiguration((CompositeLayer)this){

                protected void addAlternateRowColoringConfig(CompositeLayer gridLayer) {
                }
            });
            this.init();
        }

        private void init() {
            FormulaBodyLayerStack bodyLayer = new FormulaBodyLayerStack();
            SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
            LetterColumnHeaderDataProvider columnHeaderDataProvider = new LetterColumnHeaderDataProvider(26);
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)bodyLayer, selectionLayer);
            DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayer.getDataLayer().getDataProvider());
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider), (ILayer)bodyLayer, selectionLayer);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.setBodyLayer((ILayer)bodyLayer);
            this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
            this.setRowHeaderLayer((ILayer)rowHeaderLayer);
            this.setCornerLayer((ILayer)cornerLayer);
        }

        public FormulaBodyLayerStack getBodyLayer() {
            return (FormulaBodyLayerStack)super.getBodyLayer();
        }

        public DataLayer getBodyDataLayer() {
            return this.getBodyLayer().getDataLayer();
        }

        public FormulaDataProvider getBodyDataProvider() {
            return this.getBodyLayer().getFormulaDataProvider();
        }
    }

    class LetterColumnHeaderDataProvider
    implements IDataProvider {
        private int columns = 0;

        public LetterColumnHeaderDataProvider(int columns) {
            this.columns = columns;
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return Character.valueOf((char)(65 + columnIndex));
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }

        public int getColumnCount() {
            return this.columns;
        }

        public int getRowCount() {
            return 1;
        }
    }

    class TwoDimensionalArrayDataProvider
    implements IDataProvider {
        private String[][] data;

        public TwoDimensionalArrayDataProvider(String[][] data) {
            this.data = data;
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return this.data[columnIndex][rowIndex];
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            this.data[columnIndex][rowIndex] = newValue != null ? newValue.toString() : null;
        }

        public int getColumnCount() {
            return this.data.length;
        }

        public int getRowCount() {
            return this.data[0] != null ? this.data[0].length : 0;
        }
    }
}

