/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class DefaultResourceHyperlink
implements IHyperlink {
    private final IRegion region;
    private final String resourceName;

    public DefaultResourceHyperlink(IRegion region, String resourceName) {
        this.region = region;
        this.resourceName = resourceName;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return "Open " + this.resourceName;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.resourceName), true);
        if (resource instanceof IFile) {
            this.openEditor((IFile)resource);
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Resource", (String)"Resource could not be located.");
        }
    }

    private void openEditor(final IFile file) {
        UIJob job = new UIJob("Opening resource"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                    return Status.OK_STATUS;
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Resource", (String)"Failed to open resource.");
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

