/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.URIUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public class ClassPathUnitResolver
implements UnitResolver {
    public static ClassPathUnitResolver INSTANCE = new ClassPathUnitResolver();

    private ClassPathUnitResolver() {
    }

    public UnitProxy resolveUnit(String qualifiedName) {
        String resourcePath = ResolverUtils.toNamespaceRelativeUnitFilePath(qualifiedName);
        URL resourceUrl = ClassLoader.getSystemResource(resourcePath);
        if (resourceUrl != null) {
            try {
                int numberOfNameSegments = ResolverUtils.getNameSegments(qualifiedName).length;
                String resourceUri = URIUtil.toURI((URL)resourceUrl).toString();
                URI baseUri = URI.createURI((String)resourceUri).trimSegments(numberOfNameSegments);
                return new URIUnitResolver(baseUri).resolveUnit(qualifiedName);
            }
            catch (URISyntaxException e) {
                QvtPlugin.INSTANCE.log(e);
            }
        }
        return null;
    }
}

