/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;

public class RootPartitionAnalysis
extends AbstractCompositePartitionAnalysis<RootPartition> {
    private @Nullable RootRegion rootRegion = null;

    public static @NonNull RootPartitionAnalysis createRootPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull String name, @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionAnalysis2predecessors) {
        RootPartition rootPartition = RegionHelper.createRootPartition(name, transformationAnalysis.getScheduleManager());
        transformationAnalysis.getRootRegion().setOwnedRootPartition(rootPartition);
        RootPartitionAnalysis rootPartitionAnalysis = new RootPartitionAnalysis(partitionedTransformationAnalysis, rootPartition, partitionAnalysis2predecessors);
        return rootPartitionAnalysis;
    }

    private RootPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull RootPartition rootPartition, @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionAnalysis2predecessors) {
        super(partitionedTransformationAnalysis, rootPartition, partitionAnalysis2predecessors);
        partitionedTransformationAnalysis.setRootPartitionAnalysis(this);
    }

    @Override
    protected @NonNull List<@NonNull Concurrency> createPartitionSchedule() {
        ArrayList<@NonNull Concurrency> flatPartitionSchedule = new ArrayList<Concurrency>();
        List<@NonNull Concurrency> parallelSchedule = CompilerUtil.computeParallelSchedule(this.originalPartitionAnalysis2predecessors, TransformationPartitioner.ROOT_SCHEDULE_SUCCESSORS);
        if (TransformationPartitioner.ROOT_SCHEDULE.isActive()) {
            CompilerUtil.traceSchedule(TransformationPartitioner.ROOT_SCHEDULE, this.getName(), parallelSchedule);
        }
        for (Concurrency concurrency : parallelSchedule) {
            this.appendConcurrency(flatPartitionSchedule, concurrency);
        }
        if (TransformationPartitioner.PARALLEL_SCHEDULE.isActive()) {
            CompilerUtil.traceSchedule(TransformationPartitioner.PARALLEL_SCHEDULE, null, flatPartitionSchedule);
        }
        return flatPartitionSchedule;
    }

    public @NonNull RootRegion getRootRegion() {
        return (RootRegion)ClassUtil.nonNullState((Object)this.rootRegion);
    }

    public void setRootRegion(@NonNull RootRegion rootRegion) {
        this.rootRegion = rootRegion;
    }
}

