/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CyclicPartitionAnalysis
extends AbstractCompositePartitionAnalysis<CyclicPartition> {
    protected final @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> externalPredecessors;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull CyclicPartitionAnalysis createCyclicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull String name, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> partitionAnalyses, @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionAnalysis2predecessors) {
        HashMap<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> nestedPartitionAnalysis2predecessors = new HashMap<PartialRegionAnalysis<PartitionsAnalysis>, Set<PartialRegionAnalysis<PartitionsAnalysis>>>();
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> externalPredecessors = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>();
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : partitionAnalyses) {
            HashSet<@NonNull @NonNull E> internalPredecessors = new HashSet(partitionAnalysis2predecessors.get(partitionAnalysis));
            externalPredecessors.addAll(internalPredecessors);
            internalPredecessors.remove(partitionAnalysis);
            internalPredecessors.retainAll(partitionAnalyses);
            nestedPartitionAnalysis2predecessors.put(partitionAnalysis, internalPredecessors);
        }
        externalPredecessors.removeAll(partitionAnalyses);
        assert (!partitionAnalyses.isEmpty());
        ScheduleManager scheduleManager = partitionedTransformationAnalysis.getScheduleManager();
        CyclicPartition cyclicPartition = RegionHelper.createCyclicPartition(name, scheduleManager);
        return new CyclicPartitionAnalysis(partitionedTransformationAnalysis, cyclicPartition, nestedPartitionAnalysis2predecessors, externalPredecessors);
    }

    private CyclicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull CyclicPartition cyclicPartition, @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionAnalysis2predecessors, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> externalPredecessors) {
        super(partitionedTransformationAnalysis, cyclicPartition, partitionAnalysis2predecessors);
        this.externalPredecessors = externalPredecessors;
        partitionedTransformationAnalysis.addPartitionAnalysis(this);
        Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> cyclicPartitionAnalyses = partitionAnalysis2predecessors.keySet();
        HashSet<@NonNull PartialRegionPropertyAnalysis<@NonNull PartitionsAnalysis>> containmentPropertyPartitionAnalyses = new HashSet<PartialRegionPropertyAnalysis<PartitionsAnalysis>>();
        HashSet<@NonNull PartialRegionPropertyAnalysis<@NonNull PartitionsAnalysis>> containerPropertyPartitionAnalyses = new HashSet<PartialRegionPropertyAnalysis<PartitionsAnalysis>>();
        for (PartialRegionAnalysis<PartitionsAnalysis> consumer : cyclicPartitionAnalyses) {
            Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PartitionsAnalysis>> consumedPropertyAnalyses = consumer.getConsumedPropertyAnalyses();
            if (consumedPropertyAnalyses == null) continue;
            for (PartialRegionPropertyAnalysis<PartitionsAnalysis> consumedPropertyAnalysis : consumedPropertyAnalyses) {
                boolean isContainer;
                PropertyDatum propertyDatum = consumedPropertyAnalysis.getPropertyDatum();
                Property consumedProperty = propertyDatum.getReferredProperty();
                boolean isContainment = consumedProperty.isIsComposite();
                Property consumedOppositeProperty = consumedProperty.getOpposite();
                boolean bl = isContainer = consumedOppositeProperty != null && consumedOppositeProperty.isIsComposite();
                if (!isContainment && !isContainer) continue;
                for (PartialRegionAnalysis producer : consumedPropertyAnalysis.getCompatibleProducers()) {
                    if (!cyclicPartitionAnalyses.contains(producer)) continue;
                    Partition producingPartition = producer.getPartition();
                    for (Edge edge : producingPartition.getPartialEdges()) {
                        NavigationEdge navigationEdge;
                        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                        if (!targetNode.isRealized() || !edge.isRealized() || !edge.isNavigation() || QVTscheduleUtil.getReferredProperty((NavigationEdge)(navigationEdge = (NavigationEdge)edge)) != consumedProperty) continue;
                        if (isContainment) {
                            containmentPropertyPartitionAnalyses.add(consumedPropertyAnalysis);
                        }
                        if (!isContainer) continue;
                        containerPropertyPartitionAnalyses.add(consumedPropertyAnalysis);
                    }
                }
            }
        }
        TransformationPartitioner.CONTAINMENT.println("Containment: " + containmentPropertyPartitionAnalyses);
        TransformationPartitioner.CONTAINMENT.println("Container: " + containerPropertyPartitionAnalyses);
    }

    protected @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> computeBaseRecursingSteps(@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> recursingSteps) {
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> baseRecursingSteps = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>();
        Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> immediatePredecessors = CompilerUtil.computeImmediatePredecessors(recursingSteps, TransformationPartitioner.CYCLE_SCHEDULE_PREDECESSORS);
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : recursingSteps) {
            Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> predecessors = immediatePredecessors.get(partitionAnalysis);
            assert (predecessors != null);
            baseRecursingSteps.add(partitionAnalysis);
        }
        return baseRecursingSteps;
    }

    protected @NonNull List<@NonNull Concurrency> computeRecursiveSchedule(@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> recursingSteps) {
        Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> immediatePredecessors = CompilerUtil.computeImmediatePredecessors(recursingSteps, TransformationPartitioner.CYCLE_SCHEDULE_PREDECESSORS);
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : recursingSteps) {
            Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> predecessors = immediatePredecessors.get(partitionAnalysis);
            assert (predecessors != null);
            predecessors.retainAll(recursingSteps);
        }
        Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionAnalysis2predecessors = CompilerUtil.computeClosure(immediatePredecessors);
        return CompilerUtil.computeParallelSchedule(partitionAnalysis2predecessors, TransformationPartitioner.CYCLE_SCHEDULE_PREDECESSORS);
    }

    /*
     * WARNING - void declaration
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<@NonNull Concurrency> createPartitionSchedule() {
        assert (this.partitionAnalyses.equals(this.originalPartitionAnalysis2predecessors.keySet()));
        HashSet<@NonNull @NonNull PartialRegionAnalysis> externalPartitionAnalyses = new HashSet<PartialRegionAnalysis>();
        for (PartialRegionAnalysis consumingPartitionAnalysis : this.partitionAnalyses) {
            Object consumedPropertyAnalyses;
            assert (!this.externalPredecessors.contains(consumingPartitionAnalysis));
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> consumedClassAnalyses = consumingPartitionAnalysis.getConsumedClassAnalyses();
            if (consumedClassAnalyses != null) {
                for (PartialRegionClassAnalysis consumedClassAnalysis : consumedClassAnalyses) {
                    for (PartialRegionAnalysis partialRegionAnalysis : consumedClassAnalysis.getCompatibleProducers()) {
                        if (this.partitionAnalyses.contains(partialRegionAnalysis)) continue;
                        externalPartitionAnalyses.add(consumingPartitionAnalysis);
                    }
                }
            }
            if ((consumedPropertyAnalyses = consumingPartitionAnalysis.getConsumedPropertyAnalyses()) == null) continue;
            Iterator iterator = consumedPropertyAnalyses.iterator();
            while (iterator.hasNext()) {
                @NonNull @NonNull PartialRegionPropertyAnalysis consumedPropertyAnalysis = (PartialRegionPropertyAnalysis)iterator.next();
                for (PartialRegionAnalysis partialRegionAnalysis : consumedPropertyAnalysis.getCompatibleProducers()) {
                    if (this.partitionAnalyses.contains(partialRegionAnalysis)) continue;
                    externalPartitionAnalyses.add(consumingPartitionAnalysis);
                }
            }
        }
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> basicCases = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>();
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> recursingSteps = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>();
        for (PartialRegionAnalysis partitionAnalysis : this.partitionAnalyses) {
            void var7_14;
            Iterable<@NonNull PartialRegionAnalysis<@NonNull PRA>> rawExplicitPredecessors = partitionAnalysis.getExplicitPredecessors();
            Object var7_11 = null;
            if (rawExplicitPredecessors != null) {
                @NonNull @NonNull HashSet hashSet = Sets.newHashSet(rawExplicitPredecessors);
                hashSet.retainAll(this.partitionAnalyses);
                if (hashSet.isEmpty()) {
                    @NonNull @NonNull Object var7_13 = null;
                }
            }
            if (var7_14 != null) {
                recursingSteps.add(partitionAnalysis);
                continue;
            }
            if (externalPartitionAnalyses.contains(partitionAnalysis)) {
                basicCases.add(partitionAnalysis);
                continue;
            }
            recursingSteps.add(partitionAnalysis);
        }
        ArrayList<@NonNull Concurrency> partitionSchedule = new ArrayList<Concurrency>();
        this.appendConcurrency(partitionSchedule, basicCases);
        HashSet<PartialRegionAnalysis<PartitionsAnalysis>> residualSteps = null;
        if (recursingSteps.size() > 0) {
            Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> baseRecursingSteps = this.computeBaseRecursingSteps(recursingSteps);
            residualSteps = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>(recursingSteps);
            if (baseRecursingSteps.size() > 0) {
                residualSteps.removeAll(baseRecursingSteps);
                if (baseRecursingSteps.size() <= 1) {
                    this.appendConcurrency(partitionSchedule, baseRecursingSteps);
                } else {
                    List<@NonNull Concurrency> list = this.computeRecursiveSchedule(baseRecursingSteps);
                    for (Iterable iterable : list) {
                        this.appendConcurrency(partitionSchedule, iterable);
                    }
                }
            }
        }
        if (residualSteps != null && !residualSteps.isEmpty()) {
            List<@NonNull Concurrency> residualSchedule = this.computeRecursiveSchedule((Set<PartialRegionAnalysis<PartitionsAnalysis>>)residualSteps);
            for (Iterable iterable : residualSchedule) {
                this.appendConcurrency(partitionSchedule, iterable);
            }
        }
        ((Concurrency)partitionSchedule.get(0)).setCycleStart();
        ((Concurrency)partitionSchedule.get(partitionSchedule.size() - 1)).setCycleEnd();
        if (TransformationPartitioner.CYCLE_SCHEDULE.isActive()) {
            CompilerUtil.traceSchedule(TransformationPartitioner.CYCLE_SCHEDULE, this.getName(), partitionSchedule);
        }
        return partitionSchedule;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> getConsumedClassAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PartitionsAnalysis>> getConsumedPropertyAnalyses() {
        return null;
    }

    @Override
    public @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> getExplicitPredecessors() {
        return this.externalPredecessors;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> getProducedClassAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PartitionsAnalysis>> getProducedPropertyAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> getSuperProducedClassAnalyses() {
        return null;
    }
}

