/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.cs2as.compiler.internal.OCL2QVTm;
import org.eclipse.qvtd.cs2as.compiler.internal.QVTmModelsMerger;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;

public class OCL2QVTiCompilerChain
extends AbstractCompilerChain {
    public static final @NonNull String DEFAULT_TRACE_PROPERTY_NAME = "ast";
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CompilerOptions.Key<String> TRACE_PROPERTY_NAME_KEY = new CompilerOptions.Key("ocl2qvtm.tracePropName");
    public final @NonNull OCL2QVTmCompilerStep ocl2qvtmCompilerStep;

    public OCL2QVTiCompilerChain(@NonNull QVTimperative qvti, @NonNull CompilerOptions options, @NonNull URI oclDocURI, @NonNull URI prefixURI, URI ... extendedDocURIs) throws CompilerChainException {
        super(qvti.getEnvironmentFactory(), oclDocURI, prefixURI, options);
        this.ocl2qvtmCompilerStep = new OCL2QVTmCompilerStep((CompilerChain)this, qvti, options, oclDocURI, extendedDocURIs);
    }

    public @NonNull ImperativeTransformation compile(@NonNull String enforcedOutputName) throws IOException {
        return this.qvtm2qvti(this.ocl2qvtmCompilerStep.execute());
    }

    public @NonNull ImperativeTransformation compile() throws IOException {
        return this.compile("");
    }

    protected @NonNull ImperativeTransformation qvtm2qvti(@NonNull Resource pResource) throws IOException {
        this.rewriteSafeNavigations(pResource);
        return super.qvtm2qvti(pResource);
    }

    private void rewriteSafeNavigations(@NonNull Resource resource) {
        QVTcoreHelper helper = new QVTcoreHelper((EnvironmentFactory)this.environmentFactory);
        for (EObject rootObject : resource.getContents()) {
            if (!(rootObject instanceof Element)) continue;
            helper.rewriteSafeNavigations((Element)rootObject);
        }
    }

    public static class OCL2QVTmCompilerStep
    extends AbstractCompilerStep {
        private @NonNull URI oclASUri;
        private @NonNull List<URI> extendedASUris = new ArrayList<URI>();
        private @NonNull String traceabilityPropName = this.getTraceabilityPropertyName();

        public OCL2QVTmCompilerStep(@NonNull CompilerChain compilerChain, @NonNull QVTimperative qvti, @Nullable CompilerOptions options, @NonNull URI oclDocURI, URI ... extendedDocURIs) throws CompilerChainException {
            super(compilerChain, "QVTm");
            ResourceSet externalResourceSet = qvti.getResourceSet();
            CSResource csResource = (CSResource)externalResourceSet.getResource(oclDocURI, true);
            if (csResource == null) {
                throw new CompilerChainException("Failed to parse " + oclDocURI, new Object[0]);
            }
            ASResource asResource = qvti.cs2as(csResource);
            this.oclASUri = (URI)ClassUtil.nonNullState((Object)asResource.getURI());
            URI[] uRIArray = extendedDocURIs;
            int n = extendedDocURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI extendedDocURI = uRIArray[n2];
                csResource = (CSResource)externalResourceSet.getResource(extendedDocURI, true);
                if (csResource == null) {
                    throw new CompilerChainException("Failed to parse " + extendedDocURI, new Object[0]);
                }
                asResource = qvti.cs2as(csResource);
                this.extendedASUris.add((URI)ClassUtil.nonNullState((Object)asResource.getURI()));
                ++n2;
            }
            StringBuilder s = null;
            for (Resource resource : externalResourceSet.getResources()) {
                if (resource.getErrors().size() <= 0) continue;
                if (s == null) {
                    s = new StringBuilder();
                }
                s.append(PivotUtil.formatResourceDiagnostics((List)resource.getErrors(), (String)("\nErrors in " + resource.getURI()), (String)"\n\t"));
            }
            if (s != null) {
                throw new CompilerChainException(s.toString(), new Object[0]);
            }
        }

        public @NonNull Resource ocl2qvtm(@NonNull URI oclURI) throws IOException {
            OCL2QVTm ocl2qvtm = new OCL2QVTm((EnvironmentFactory)this.environmentFactory, this.traceabilityPropName);
            Resource pResource = ocl2qvtm.run(this.environmentFactory.getMetamodelManager().getASResourceSet(), oclURI, this.getURI());
            this.saveResource(pResource);
            return pResource;
        }

        protected Resource execute() throws IOException {
            Resource mModel = this.ocl2qvtm(this.oclASUri);
            if (!this.extendedASUris.isEmpty()) {
                ArrayList<Resource> qvtmModels = new ArrayList<Resource>();
                for (URI extendedQVTpModel : this.extendedASUris) {
                    qvtmModels.add(this.ocl2qvtm(extendedQVTpModel));
                }
                QVTmModelsMerger.merge((EnvironmentFactory)this.environmentFactory, mModel, qvtmModels);
                this.saveResource(mModel, "QVTm");
                for (Resource qvtmModel : qvtmModels) {
                    qvtmModel.unload();
                }
            }
            return mModel;
        }

        private @NonNull String getTraceabilityPropertyName() {
            String tracePropName = (String)this.compilerChain.basicGetOption("QVTm", TRACE_PROPERTY_NAME_KEY);
            return tracePropName == null ? OCL2QVTiCompilerChain.DEFAULT_TRACE_PROPERTY_NAME : tracePropName;
        }
    }
}

