/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.StatusNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculatedPartition
extends AbstractPartition {
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public SpeculatedPartition(@NonNull MappingPartitioner partitioner) {
        super(partitioner);
        this.resolveTraceNodes();
        this.resolveRealizedOutputNodes();
        this.resolveRealizedEdges();
        this.resolveTrueNodes();
        this.resolvePrecedingNodes();
        this.resolveDisambiguations();
        this.resolveEdges();
        this.resolveStatusNodes();
    }

    @Override
    public @NonNull MicroMappingRegion createMicroMappingRegion(@NonNull String namePrefix, @NonNull String symbolSuffix) {
        MicroMappingRegion microMappingRegion = super.createMicroMappingRegion(namePrefix, symbolSuffix);
        return microMappingRegion;
    }

    @Override
    protected @NonNull PartitioningVisitor createPartitioningVisitor(@NonNull MicroMappingRegion partialRegion) {
        return new PartitioningVisitor(new RegionHelper<MicroMappingRegion>(this.scheduleManager, partialRegion), this){

            public @Nullable Element visitStatusNode(@NonNull StatusNode node) {
                Node partialNode = this.regionHelper.createTrueNode();
                this.addNode((Node)node, partialNode);
                return partialNode;
            }
        };
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Object edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
            edgeRole = edge.getEdgeTarget().isConstant() ? null : Role.PREDICATED;
        }
        return edgeRole;
    }

    protected void resolveRealizedEdges() {
        for (Edge edge : this.partitioner.getRealizedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (this.partitioner.hasRealizedEdge(edge) || this.partitioner.getCorrolaryOf(edge) != null || (sourceNode = edge.getEdgeSource()).isPredicated() && !this.partitioner.hasPredicatedNode(sourceNode) || (targetNode = edge.getEdgeTarget()).isPredicated() && !this.partitioner.hasPredicatedNode(targetNode)) continue;
            if (!this.hasNode(sourceNode)) {
                this.addNode(sourceNode, QVTscheduleUtil.getNodeRole((Node)sourceNode));
            }
            if (this.hasNode(targetNode)) continue;
            this.addNode(targetNode, QVTscheduleUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolveRealizedOutputNodes() {
        for (Node node : this.partitioner.getCorrolaryNodes()) {
            if (this.hasNode(node)) continue;
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
        }
    }

    protected void resolveStatusNodes() {
        for (Node traceNode : this.partitioner.getTraceNodes()) {
            assert (traceNode.isMatched() && traceNode.isClass() && traceNode.isPattern());
            Node statusNode = this.partitioner.getStatusNode(traceNode);
            if (statusNode == null) continue;
            this.addNode(statusNode, Role.PREDICATED);
        }
    }

    protected void resolveTraceNodes() {
        for (Node traceNode : this.partitioner.getTraceNodes()) {
            assert (traceNode.isMatched() && traceNode.isClass() && traceNode.isPattern());
            this.addNode(traceNode, Role.PREDICATED);
            Node statusNode = this.partitioner.getStatusNode(traceNode);
            if (statusNode == null) continue;
            this.addNode(statusNode, Role.PREDICATED);
        }
        for (Node traceNode : this.partitioner.getTraceNodes()) {
            for (NavigableEdge edge : traceNode.getNavigationEdges()) {
                if (!this.partitioner.hasRealizedEdge((Edge)edge)) continue;
                this.tracedInputNodes.add(edge.getEdgeTarget());
            }
        }
    }
}

