/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.compiler;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.Messages;
import org.eclipse.m2m.atl.engine.compiler.Atl2004Compiler;
import org.eclipse.m2m.atl.engine.compiler.AtlStandaloneCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompilerNotFoundException;
import org.eclipse.m2m.atl.engine.compiler.atl2006.Atl2006Compiler;
import org.eclipse.m2m.atl.engine.compiler.atl2010.Atl2010InPlace;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

public final class AtlCompiler {
    public static final String DEFAULT_COMPILER_NAME = "atl2006";
    private static final int MAX_LINE_LENGTH = 1000;
    private static Map compilers = new HashMap();

    private AtlCompiler() {
    }

    public static AtlStandaloneCompiler getCompiler(String compilerName) {
        AtlStandaloneCompiler ret = (AtlStandaloneCompiler)compilers.get(compilerName);
        if (ret == null) {
            block16: {
                if ("atl2010".equals(compilerName)) {
                    ret = new Atl2010InPlace();
                    compilers.put(compilerName, ret);
                } else if (DEFAULT_COMPILER_NAME.equals(compilerName)) {
                    ret = new Atl2006Compiler();
                    compilers.put(compilerName, ret);
                } else if ("atl2004".equals(compilerName)) {
                    ret = new Atl2004Compiler();
                    compilers.put(compilerName, ret);
                } else {
                    try {
                        IExtensionRegistry registry = Platform.getExtensionRegistry();
                        if (registry == null) {
                            throw new CompilerNotFoundException(Messages.getString("AtlCompiler.REGISTRYNOTFOUND"));
                        }
                        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.atlcompiler");
                        IExtension[] extensions = point.getExtensions();
                        int i = 0;
                        while (i < extensions.length) {
                            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                            int j = 0;
                            while (j < elements.length) {
                                block15: {
                                    try {
                                        if (!elements[j].getAttribute("name").equals(compilerName)) break block15;
                                        ret = (AtlStandaloneCompiler)elements[j].createExecutableExtension("class");
                                        compilers.put(compilerName, ret);
                                        break block16;
                                    }
                                    catch (CoreException e) {
                                        throw new CompilerNotFoundException(e.getLocalizedMessage());
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (ret == null) {
                throw new CompilerNotFoundException(Messages.getString("AtlCompiler.COMPILERNOTFOUND", new Object[]{compilerName}));
            }
        }
        return ret;
    }

    public static EObject[] compile(Reader in, IFile out) throws IOException {
        EObject[] ret = AtlCompiler.compile(in, out.getLocation().toString());
        try {
            out.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return ret;
    }

    public static EObject[] compile(Reader in, String outputFileName) throws IOException {
        EObject[] ret = null;
        String atlcompiler = null;
        BufferedReader newIn = new BufferedReader(in, 1000);
        newIn.mark(1000);
        char[] buffer = new char[1000];
        newIn.read(buffer);
        atlcompiler = AtlSourceManager.getCompilerName(AtlSourceManager.getTaggedInformations(new BufferedReader(new CharArrayReader(buffer)), "atlcompiler"));
        newIn.reset();
        ret = AtlCompiler.getCompiler(atlcompiler).compileWithProblemModel((Reader)newIn, outputFileName);
        return ret;
    }

    public static EObject[] compile(InputStream in, OutputStream outputStream) throws IOException {
        EObject[] ret = null;
        String atlcompiler = null;
        InputStream newIn = in;
        newIn = new BufferedInputStream(newIn, 1000);
        newIn.mark(1000);
        byte[] buffer = new byte[1000];
        newIn.read(buffer);
        atlcompiler = AtlSourceManager.getCompilerName(AtlSourceManager.getTaggedInformations(buffer, "atlcompiler"));
        newIn.reset();
        ret = AtlCompiler.getCompiler(atlcompiler).compileWithProblemModel(newIn, outputStream);
        return ret;
    }
}

