/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.LineNumber;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;
import org.eclipse.m2m.atl.emftvm.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackFrame {
    private static final Object[] EMPTY = new Object[0];
    private final ExecEnv env;
    private final StackFrame parent;
    private final CodeBlock codeBlock;
    private final Method nativeMethod;
    private String opName;
    private final Object[] locals;
    private final Object[] stack;
    private int sp = -1;
    private int pc = -1;

    public StackFrame(ExecEnv env, CodeBlock codeBlock) {
        this.env = env;
        this.parent = null;
        this.codeBlock = codeBlock;
        this.nativeMethod = null;
        this.locals = new Object[codeBlock.getMaxLocals()];
        this.stack = new Object[codeBlock.getMaxStack()];
    }

    public StackFrame(StackFrame parent, CodeBlock codeBlock) {
        this.env = parent.env;
        this.parent = parent;
        this.codeBlock = codeBlock;
        this.nativeMethod = null;
        this.locals = new Object[codeBlock.getMaxLocals()];
        this.stack = new Object[codeBlock.getMaxStack()];
    }

    public StackFrame(StackFrame parent, Method nativeMethod) {
        this.env = parent.env;
        this.parent = parent;
        this.codeBlock = null;
        this.nativeMethod = nativeMethod;
        this.locals = EMPTY;
        this.stack = EMPTY;
    }

    public StackFrame(StackFrame parent, String opName) {
        this.env = parent.env;
        this.parent = parent;
        this.codeBlock = null;
        this.nativeMethod = null;
        this.locals = EMPTY;
        this.stack = EMPTY;
        this.opName = opName;
    }

    public void push(Object value) {
        this.stack[++this.sp] = value;
    }

    public Object pop() {
        return this.stack[this.sp--];
    }

    public void popv() {
        --this.sp;
    }

    public Object[] pop(int n) {
        Object[] result = new Object[n];
        this.sp -= n;
        System.arraycopy(this.stack, this.sp + 1, result, 0, n);
        return result;
    }

    public <T> T[] pop(int n, T[] result) {
        this.sp -= n;
        System.arraycopy(this.stack, this.sp + 1, result, 0, n);
        return result;
    }

    public Object peek() {
        return this.stack[this.sp];
    }

    public boolean stackEmpty() {
        return this.sp == -1;
    }

    private StackFrame getStackFrameFor(CodeBlock cb) {
        StackFrame parent = this.parent;
        while (parent != null) {
            if (parent.codeBlock == cb) {
                return parent;
            }
            parent = parent.parent;
        }
        return null;
    }

    private CodeBlock getCodeBlock(int cbOffset) {
        CodeBlock cb = this.codeBlock;
        int i = 0;
        while (i < cbOffset) {
            cb = cb.getNestedFor();
            ++i;
        }
        return cb;
    }

    public void setLocal(Object value, int cbOffset, int slot) {
        if (cbOffset > 0) {
            try {
                CodeBlock cb = this.getCodeBlock(cbOffset);
                StackFrame parent = this.getStackFrameFor(cb);
                parent.locals[slot] = value;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot address super-block local variable %d from %s", slot, this), e);
            }
        } else {
            this.locals[slot] = value;
        }
    }

    public void setLocal(Object value, int slot) {
        this.locals[slot] = value;
    }

    public void setLocals(Object self, Object[] values) {
        this.locals[0] = self;
        System.arraycopy(values, 0, this.locals, 1, values.length);
    }

    public void setLocals(Object[] values) {
        System.arraycopy(values, 0, this.locals, 0, values.length);
    }

    public Object getLocal(int cbOffset, int slot) {
        if (cbOffset > 0) {
            try {
                CodeBlock cb = this.getCodeBlock(cbOffset);
                StackFrame parent = this.getStackFrameFor(cb);
                return parent.locals[slot];
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot address super-block local variable %d from %s", slot, this), e);
            }
        }
        return this.locals[slot];
    }

    public Object getLocal(int slot) {
        return this.locals[slot];
    }

    public void load(int cbOffset, int slot) {
        this.stack[++this.sp] = this.getLocal(cbOffset, slot);
    }

    public void store(int cbOffset, int slot) {
        this.setLocal(this.stack[this.sp--], cbOffset, slot);
    }

    public void dup() {
        ++this.sp;
        this.stack[this.sp] = this.stack[this.sp - 1];
    }

    public void dupX1() {
        ++this.sp;
        int sp1 = this.sp - 1;
        int sp2 = sp1 - 1;
        this.stack[this.sp] = this.stack[sp1];
        this.stack[sp1] = this.stack[sp2];
        this.stack[sp2] = this.stack[this.sp];
    }

    public void swap() {
        Object top = this.stack[this.sp];
        int sp1 = this.sp - 1;
        this.stack[this.sp] = this.stack[sp1];
        this.stack[sp1] = top;
    }

    public void swapX1() {
        Object top = this.stack[this.sp];
        int sp1 = this.sp - 1;
        int sp2 = this.sp - 2;
        this.stack[this.sp] = this.stack[sp2];
        this.stack[sp2] = this.stack[sp1];
        this.stack[sp1] = top;
    }

    public StackFrame getParent() {
        return this.parent;
    }

    public CodeBlock getCodeBlock() {
        return this.codeBlock;
    }

    public ExecEnv getEnv() {
        return this.env;
    }

    public Method getNativeMethod() {
        return this.nativeMethod;
    }

    public String toString() {
        Module module;
        CodeBlock cb = this.getCodeBlock();
        int loc = this.getLocation();
        StringBuffer sb = new StringBuffer("at ");
        sb.append(this.getOpName());
        if (loc > -1) {
            sb.append('#');
            sb.append(loc);
            if (cb != null) {
                sb.append('(');
                module = cb.getModule();
                if (module != null) {
                    sb.append(module);
                } else {
                    sb.append("<unknown>");
                }
                String sloc = this.getSourceLocation();
                if (sloc != null) {
                    sb.append("#[");
                    sb.append(sloc);
                    sb.append(']');
                }
                sb.append(')');
            }
        } else if (cb != null) {
            sb.append('(');
            module = cb.getModule();
            if (module != null) {
                sb.append(module);
            } else {
                sb.append("<unknown>");
            }
            sb.append(')');
        }
        sb.append("\n\tLocal variables: ");
        if (cb != null && loc > -1) {
            sb.append('[');
            boolean first = true;
            int slot = 0;
            while (slot < this.locals.length) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                for (LocalVariable lv : cb.getLocalVariables()) {
                    if (lv.getSlot() != slot || lv.getStartInstructionIndex() > loc || lv.getEndInstructionIndex() < loc) continue;
                    sb.append(lv.toString());
                    sb.append(" = ");
                    sb.append(EMFTVMUtil.toPrettyString(this.locals[slot], this.getEnv()));
                    break;
                }
                ++slot;
            }
            sb.append(']');
        } else {
            sb.append(EMFTVMUtil.toPrettyString(this.locals, this.getEnv()));
        }
        StackFrame parent = this.getParent();
        if (parent != null) {
            sb.append('\n');
            sb.append(parent.toString());
        }
        return sb.toString();
    }

    public void setPc(int pc) {
        this.pc = pc;
    }

    public int getPc() {
        return this.pc;
    }

    public StackFrame getSubFrame(CodeBlock cb, Object[] args) {
        StackFrame frame = new StackFrame(this, cb);
        frame.setLocals(args);
        return frame;
    }

    public StackFrame getSubFrame(CodeBlock cb, Object context, Object[] args) {
        StackFrame frame = new StackFrame(this, cb);
        frame.setLocals(context, args);
        return frame;
    }

    public StackFrame getSubFrame(CodeBlock cb, Object context) {
        StackFrame frame = new StackFrame(this, cb);
        frame.locals[0] = context;
        return frame;
    }

    public StackFrame getSubFrame(CodeBlock cb, Object context, Object arg) {
        StackFrame frame = new StackFrame(this, cb);
        frame.locals[0] = context;
        frame.locals[1] = arg;
        return frame;
    }

    public StackFrame prepareNativeArgs(Method method, Object[] args) {
        StackFrame subFrame = null;
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            if (arg instanceof CodeBlock) {
                if (subFrame == null) {
                    subFrame = new StackFrame(this, method);
                }
                ((CodeBlock)arg).setParentFrame(subFrame);
            } else if (arg instanceof EnumLiteral) {
                args[i] = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[i]);
            }
            ++i;
        }
        return subFrame;
    }

    public StackFrame prepareNativeArgs(Method method, Object context, Object[] args) {
        StackFrame subFrame = null;
        if (context instanceof CodeBlock) {
            subFrame = new StackFrame(this, method);
            ((CodeBlock)context).setParentFrame(subFrame);
        }
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            if (arg instanceof CodeBlock) {
                if (subFrame == null) {
                    subFrame = new StackFrame(this, method);
                }
                ((CodeBlock)arg).setParentFrame(subFrame);
            } else if (arg instanceof EnumLiteral) {
                args[i] = EMFTVMUtil.convertEnumLiteral((EnumLiteral)arg, method.getParameterTypes()[i]);
            }
            ++i;
        }
        return subFrame;
    }

    public StackFrame prepareNativeContext(Method method, Object context) {
        StackFrame subFrame = null;
        if (context instanceof CodeBlock) {
            subFrame = new StackFrame(this, method);
            ((CodeBlock)context).setParentFrame(subFrame);
        }
        return subFrame;
    }

    public LazyList<StackFrame> getStack() {
        LazyList<StackFrame> res = new LazyList<StackFrame>();
        StackFrame f = this;
        while (f != null) {
            res = res.prepend(f);
            f = f.getParent();
        }
        return res;
    }

    public Map<String, Object> getLocalVariables() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int slot = 0;
        while (slot < this.locals.length) {
            ret.put(String.valueOf(slot), this.locals[slot]);
            ++slot;
        }
        return ret;
    }

    public String resolveVariableName(int slot) {
        CodeBlock cb = this.getCodeBlock();
        int loc = this.getLocation();
        if (cb != null && loc > -1) {
            for (LocalVariable lv : cb.getLocalVariables()) {
                if (lv.getSlot() != slot || lv.getStartInstructionIndex() > loc || lv.getEndInstructionIndex() < loc) continue;
                return lv.getName();
            }
        }
        return String.valueOf(slot);
    }

    public CodeBlock getOperation() {
        CodeBlock cb = this.getCodeBlock();
        if (cb == null) {
            cb = this.getParent().getOperation();
        }
        return cb;
    }

    public int getLocation() {
        return this.getPc() - 1;
    }

    public String getSourceLocation() {
        LineNumber ln = this.getLineNumber();
        if (ln != null) {
            return ln.toString();
        }
        return null;
    }

    public LineNumber getLineNumber() {
        LineNumber ln;
        int location = this.getLocation();
        CodeBlock cb = this.getCodeBlock();
        if (location > -1 && cb != null && (ln = ((Instruction)cb.getCode().get(location)).getLineNumber()) != null) {
            return ln;
        }
        return null;
    }

    public String getOpName() {
        if (this.opName == null) {
            Method m;
            CodeBlock cb = this.getCodeBlock();
            this.opName = cb != null ? cb.toString() : ((m = this.getNativeMethod()) != null ? m.toString() : "<unknown>");
        }
        return this.opName;
    }
}

