/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMEmitter;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMXMLReader
extends DefaultHandler {
    private Object asmNameIndex;
    private ASMEmitter asme;
    private ArrayList cp = new ArrayList();
    private boolean inCode;
    private int errors;

    public ASM read(InputStream in) {
        this.asme = new ASMEmitter();
        this.asme.newUnnamedASM();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            this.errors = 0;
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)this);
        }
        catch (Throwable err) {
            ATLLogger.log((Level)Level.SEVERE, (String)err.getLocalizedMessage(), (Throwable)err);
        }
        if (this.errors > 0) {
            throw new RuntimeException("error reading .asm file");
        }
        return this.asme.getASM();
    }

    private String resolve(Object index) {
        int idx = this.toInt(index);
        return (String)this.cp.get(idx);
    }

    private int toInt(Object s) {
        return Integer.parseInt((String)s);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            attrs.put(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        if (qName.equals("asm")) {
            this.asmNameIndex = attrs.get("name");
            Object version = attrs.get("version");
            if (version != null) {
                this.asme.setVersion(version.toString());
            }
        } else if (!qName.equals("cp")) {
            if (qName.equals("constant")) {
                this.cp.add(attrs.get("value"));
            } else if (qName.equals("field")) {
                this.asme.addField(this.resolve(attrs.get("name")), this.resolve(attrs.get("type")));
            } else if (qName.equals("operation")) {
                this.asme.addOperationWithoutLVE(this.resolve(attrs.get("name")));
            } else if (qName.equals("context")) {
                this.asme.setContext(this.resolve(attrs.get("type")));
            } else if (!qName.equals("parameters")) {
                if (qName.equals("parameter")) {
                    this.asme.addParameterWithoutLVE(this.resolve(attrs.get("name")), this.resolve(attrs.get("type")));
                } else if (qName.equals("code")) {
                    this.inCode = true;
                } else if (!qName.equals("linenumbertable")) {
                    if (qName.equals("lne")) {
                        this.asme.addLineNumberEntry(this.resolve(attrs.get("id")), this.toInt(attrs.get("begin")), this.toInt(attrs.get("end")));
                    } else if (!qName.equals("localvariabletable")) {
                        if (qName.equals("lve")) {
                            this.asme.addLocalVariableEntry(this.toInt(attrs.get("slot")), this.resolve(attrs.get("name")), this.toInt(attrs.get("begin")), this.toInt(attrs.get("end")));
                        } else if (this.inCode) {
                            if (attrs.containsKey("arg")) {
                                this.asme.emitWithoutLabel(qName, this.resolve(attrs.get("arg")));
                            } else {
                                this.asme.emitSimple(qName);
                            }
                        }
                    }
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("cp")) {
            this.asme.setName(this.resolve(this.asmNameIndex));
        } else if (qName.equals("code")) {
            this.inCode = false;
        }
    }

    public void error(SAXParseException e) {
        ATLLogger.severe((String)("Error: line " + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + e.getMessage()));
        ++this.errors;
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        throw new ASMXMLReaderException("Fatal error reading .asm file: line " + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + e.getLocalizedMessage(), e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e);
    }
}

