/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.ui.opener;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.ui.editor.LanguageSpecificURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;

public class LibraryURIEditorOpener
extends LanguageSpecificURIEditorOpener {
    @Inject(optional=true)
    private IWorkbench workbench;

    public IEditorPart open(URI uri, EReference crossReference, int indexInList, boolean select) {
        if (uri.isPlatformPlugin() && this.workbench != null) {
            IWorkbenchPage activePage = this.workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)new XtextReadonlyEditorInput((IStorage)new URIStorage(uri)), (String)this.getEditorId());
                this.selectAndReveal(editor, uri, crossReference, indexInList, select);
                return editor;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return super.open(uri, crossReference, indexInList, select);
    }

    public static class URIStorage
    implements IStorage {
        private final URI uri;
        private URIConverter converter;

        public URIStorage(URI uri) {
            this.uri = uri;
            this.converter = new ExtensibleURIConverterImpl();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            Map<String, URIConverter> options = Collections.singletonMap("URI_CONVERTER", this.converter);
            try {
                return this.converter.createInputStream(this.converter.normalize(this.uri), options);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public IPath getFullPath() {
            URI normalized = this.converter.normalize(this.uri);
            String path = normalized.isRelative() ? normalized.toString() : normalized.toString();
            return new Path(path);
        }

        public String getName() {
            return URI.decode((String)this.converter.normalize(this.uri).lastSegment());
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

