/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class GyroscopeSensorFusionGenerator
extends AbstractSystemResourceGenerator {
    public static final String CONFIG_ITEM_POWER_MODE = "power_mode";
    public static final String CONFIG_ITEM_STANDBY_TIME = "standby_time";
    public static final String CONFIG_ITEM_TEMPERATURE_OVERSAMPLING = "temperature_oversampling";
    public static final String CONFIG_ITEM_PRESSURE_OVERSAMPLING = "pressure_oversampling";
    public static final String CONFIG_ITEM_HUMIDITY_OVERSAMPLING = "humidity_oversampling";
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = CalibratedGyro_init(xdkCalibratedGyroscope_Handle);");
                _builder.newLine();
                CharSequence _generateExceptionHandler = GyroscopeSensorFusionGenerator.this._generatorUtils.generateExceptionHandler((EObject)GyroscopeSensorFusionGenerator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Retcode.h", true, 750).addHeader("XdkSensorHandle.h", true).addHeader("BCDS_CalibratedGyro.h", true);
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateAccessPreparationFor(ModalityAccessPreparation accessPreparation) {
        final String xyzData = this.getDataVariable(accessPreparation);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"CalibratedGyro_XyzDpsData_T ");
                _builder.append((Object)xyzData);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = CalibratedGyro_readXyzDpsValue(&");
                _builder.append((Object)xyzData);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = GyroscopeSensorFusionGenerator.this._generatorUtils.generateExceptionHandler((EObject)GyroscopeSensorFusionGenerator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Gyroscope.h", true).addHeader("XdkSensorHandle.h", true);
    }

    public String getDataVariable(ModalityAccessPreparation preparation) {
        return StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)preparation));
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modalityAccess) {
        final String xyzData = this.getDataVariable(modalityAccess.getPreparation());
        String modalityName = modalityAccess.getModality().getName();
        CodeFragment _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)modalityName, (Object)"x_axis")) {
            _matched = true;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)xyzData);
                    _builder.append((Object)".xAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"y_axis")) {
            _matched = true;
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)xyzData);
                    _builder.append((Object)".yAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_1);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"z_axis")) {
            _matched = true;
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)xyzData);
                    _builder.append((Object)".zAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_2);
        }
        return _switchResult;
    }
}

