/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Bmi160Generator
extends AbstractSystemResourceGenerator {
    public static final String CONFIG_ITEM_POWER_MODE = "power_mode";
    public static final String CONFIG_ITEM_STANDBY_TIME = "standby_time";
    public static final String CONFIG_ITEM_TEMPERATURE_OVERSAMPLING = "temperature_oversampling";
    public static final String CONFIG_ITEM_PRESSURE_OVERSAMPLING = "pressure_oversampling";
    public static final String CONFIG_ITEM_HUMIDITY_OVERSAMPLING = "humidity_oversampling";
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_init(xdkGyroscope_BMI160_Handle);");
                _builder.newLine();
                CharSequence _generateExceptionHandler = Bmi160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmi160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/* Set Bandwidth */");
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_setBandwidth(xdkGyroscope_BMI160_Handle, ");
                String _bmiBandwidthEnumValue = Bmi160Generator.this.getBmiBandwidthEnumValue(Bmi160Generator.this.configuration);
                _builder.append((Object)_bmiBandwidthEnumValue);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler_1 = Bmi160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmi160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_1);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"/* Set Powermode */");
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_setMode(xdkGyroscope_BMI160_Handle, GYROSCOPE_BMI160_POWERMODE_NORMAL);");
                _builder.newLine();
                CharSequence _generateExceptionHandler_2 = Bmi160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmi160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Set Range */");
                _builder.newLine();
                _builder.append((Object)"exception = Gyroscope_setRange(xdkGyroscope_BMI160_Handle, ");
                String _bmiRangeEnumValue = Bmi160Generator.this.getBmiRangeEnumValue(Bmi160Generator.this.configuration);
                _builder.append((Object)_bmiRangeEnumValue);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler_3 = Bmi160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmi160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler_3);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Retcode.h", true, 750).addHeader("XdkSensorHandle.h", true).addHeader("BCDS_Gyroscope.h", true);
    }

    public String getBmiBandwidthEnumValue(IComponentConfiguration config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GYROSCOPE_BMI160_BANDWIDTH_");
        Enumerator _enumerator = config.getEnumerator("bandwidth");
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String _upperCase = null;
        if (_name != null) {
            _upperCase = _name.toUpperCase();
        }
        String _substring = _upperCase.substring(3);
        _builder.append(_substring);
        return _builder.toString();
    }

    public String getBmiRangeEnumValue(IComponentConfiguration config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("GYROSCOPE_BMI160_");
        Enumerator _enumerator = config.getEnumerator("range");
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String _upperCase = null;
        if (_name != null) {
            _upperCase = _name.toUpperCase();
        }
        String _substring = _upperCase.substring(6);
        _builder.append(_substring);
        _builder.append("_RANGE");
        return _builder.toString();
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateAccessPreparationFor(final ModalityAccessPreparation accessPreparation) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Gyroscope_XyzData_T ");
                String _dataVariable = Bmi160Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = Gyroscope_readXyzValue(xdkGyroscope_BMI160_Handle, &");
                String _dataVariable_1 = Bmi160Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable_1);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = Bmi160Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmi160Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Gyroscope.h", true).addHeader("XdkSensorHandle.h", true);
    }

    public String getDataVariable(ModalityAccessPreparation preparation) {
        return StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)preparation));
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modalityAccess) {
        final String dataVariable = this.getDataVariable(modalityAccess.getPreparation());
        String modalityName = modalityAccess.getModality().getName();
        CodeFragment _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)modalityName, (Object)"x_axis")) {
            _matched = true;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".xAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"y_axis")) {
            _matched = true;
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".yAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_1);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"z_axis")) {
            _matched = true;
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".zAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_2);
        }
        return _switchResult;
    }
}

