/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.inject.Inject;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class ServalPALGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;

    public CodeFragment generateSetup(final boolean isSecure) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.newLine();
                _builder.append((Object)"/**< Handle for Serval PAL thread command processor */");
                _builder.newLine();
                _builder.append((Object)"static CmdProcessor_T ServalPALCmdProcessorHandle;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = CmdProcessor_Initialize(&ServalPALCmdProcessorHandle, \"Serval PAL\", TASK_PRIORITY_SERVALPAL_CMD_PROC, TASK_STACK_SIZE_SERVALPAL_CMD_PROC, TASK_QUEUE_LEN_SERVALPAL_CMD_PROC);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == exception)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"exception = ServalPal_Initialize(&ServalPALCmdProcessorHandle);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == exception)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"exception = ServalPalWiFi_Init();");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#define TASK_PRIORITY_SERVALPAL_CMD_PROC            UINT32_C(3)");
                _builder.newLine();
                _builder.append((Object)"#define TASK_STACK_SIZE_SERVALPAL_CMD_PROC          UINT32_C(");
                if (isSecure) {
                    _builder.append((Object)"2000");
                } else {
                    _builder.append((Object)"600");
                }
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"#define TASK_QUEUE_LEN_SERVALPAL_CMD_PROC           UINT32_C(10)");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("BCDS_ServalPalWiFi.h", true, 750).addHeader("BCDS_ServalPal.h", true, 750);
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK == exception)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"exception = ServalPalWiFi_NotifyWiFiEvent(SERVALPALWIFI_CONNECTED, NULL);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK != exception)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_ServalPalWiFi.h", true, 750).addHeader("BCDS_ServalPal.h", true, 750);
    }
}

