/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.inject.Inject;
import java.net.URL;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.xdk110.connectivity.ServalPALGenerator;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RestClientGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected TypeGenerator typeGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;
    @Inject
    protected ServalPALGenerator servalpalGenerator;

    public CodeFragment generateAdditionalImplementation() {
        try {
            CodeFragment _xblockexpression = null;
            int httpBodyBufferSize = 512;
            String _string = this.configuration.getString("endpointBase");
            final URL baseUrl = new URL(_string);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @brief API responsible to pass the payload to the requested URL");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param[in] omsh_ptr This data structure is used hold the buffer and information needed by the serializer.");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t httpPayloadSerializer(OutMsgSerializationHandover_T* omsh_ptr)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"uint32_t offset = omsh_ptr->offset;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"uint32_t bytesLeft = strlen(httpBodyBuffer) - offset;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"uint32_t bytesToCopy = omsh_ptr->bufLen > bytesLeft ? bytesLeft : omsh_ptr->bufLen;");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"memcpy(omsh_ptr->buf_ptr, httpBodyBuffer + offset, bytesToCopy);");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"omsh_ptr->len = bytesToCopy;");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"if(bytesToCopy < bytesLeft) {");
                    _builder.newLine();
                    _builder.append((Object)"    \t");
                    _builder.append((Object)"return RC_MSG_FACTORY_INCOMPLETE;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"} else {");
                    _builder.newLine();
                    _builder.append((Object)"    \t");
                    _builder.append((Object)"return RC_OK;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t httpClientResponseCallback(HttpSession_T *httpSession, Msg_T *msg_ptr, retcode_t status) ");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"responseRetcode = status;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"responseStatusCode = HttpMsg_getStatusCode(msg_ptr);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"xSemaphoreGive(responseReceivedSemaphore);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return RC_OK;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t httpClientOnSentCallback(Callable_T *callfunc, retcode_t status) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"(status == RC_OK ? \"OK\" : \"FAILED\")");
                        }
                    };
                    CodeFragment _generateLogStatement = RestClientGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Debug, "Send HTTP request %s", new CodeFragment[]{RestClientGenerator.this.codeFragmentProvider.create(_client)});
                    _builder.append((Object)_generateLogStatement, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return status;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            CodeFragment _create = this.codeFragmentProvider.create(_client);
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"static char httpBodyBuffer[");
                    _builder.append((Object)512);
                    _builder.append((Object)"];");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static SemaphoreHandle_t responseReceivedSemaphore;");
                    _builder.newLine();
                    _builder.append((Object)"static Http_StatusCode_T responseStatusCode;");
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t responseRetcode;");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"#define ");
                    String _upperCase = RestClientGenerator.this._generatorUtils.getBaseName((Object)RestClientGenerator.this.setup).toUpperCase();
                    _builder.append((Object)_upperCase);
                    _builder.append((Object)"_TIMEOUT (20000 / portTICK_PERIOD_MS)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"#define ");
                    String _upperCase_1 = RestClientGenerator.this._generatorUtils.getBaseName((Object)RestClientGenerator.this.setup).toUpperCase();
                    _builder.append((Object)_upperCase_1);
                    _builder.append((Object)"_HOST    \"");
                    String _host = baseUrl.getHost();
                    _builder.append((Object)_host);
                    _builder.append((Object)"\"");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t httpPayloadSerializer(OutMsgSerializationHandover_T* omsh_ptr);");
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t httpClientResponseCallback(HttpSession_T *httpSession, Msg_T *msg_ptr, retcode_t status);");
                    _builder.newLine();
                    _builder.append((Object)"static retcode_t httpClientOnSentCallback(Callable_T *callfunc, retcode_t status);");
                    _builder.newLine();
                }
            };
            _xblockexpression = _create.setPreamble(_client_1).addHeader("Serval_Http.h", true).addHeader("stdio.h", true).addHeader("FreeRTOS.h", true, 750).addHeader("semphr.h", true);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CodeFragment generateSignalInstanceSetter(SignalInstance signalInstance, final String variableName) {
        try {
            CodeFragment _xblockexpression = null;
            String _string = this.configuration.getString("endpointBase");
            URL baseUrl = new URL(_string);
            final String httpMethod = this.getHttpMethod(ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"writeMethod"));
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            final Object contentType = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"contentType"), (Procedures.Procedure1)_function);
            StringConcatenation _builder = new StringConcatenation();
            String _path = baseUrl.getPath();
            _builder.append(_path);
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Object _infer = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"endpoint"), (Procedures.Procedure1)_function_1);
            _builder.append(_infer);
            final String url = _builder.toString();
            int _xifexpression = 0;
            int _port = baseUrl.getPort();
            boolean _lessThan = _port < 0;
            _xifexpression = _lessThan ? 80 : baseUrl.getPort();
            final int port = _xifexpression;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"size_t messageLength = strlen((const char*) *");
                    _builder.append((Object)variableName);
                    _builder.append((Object)") + 1;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(messageLength > sizeof(httpBodyBuffer))");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return EXCEPTION_INDEXOUTOFBOUNDSEXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"memcpy(httpBodyBuffer, *");
                    _builder.append((Object)variableName);
                    _builder.append((Object)", messageLength);");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                    _builder.newLine();
                    _builder.append((Object)"Ip_Address_T destAddr;");
                    _builder.newLine();
                    _builder.append((Object)"exception = NetworkConfig_GetIpAddress((uint8_t*) ");
                    String _upperCase = RestClientGenerator.this._generatorUtils.getBaseName((Object)RestClientGenerator.this.setup).toUpperCase();
                    _builder.append((Object)_upperCase);
                    _builder.append((Object)"_HOST, &destAddr);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (exception != RETCODE_OK)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"retcode_t rc;");
                    _builder.newLine();
                    _builder.append((Object)"Msg_T* msg_ptr;");
                    _builder.newLine();
                    _builder.append((Object)"rc = HttpClient_initRequest(&destAddr, Ip_convertIntToPort(");
                    _builder.append((Object)port);
                    _builder.append((Object)"), &msg_ptr);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (rc != RC_OK || msg_ptr == NULL)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return rc;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"HttpMsg_setReqMethod(msg_ptr, ");
                    _builder.append((Object)httpMethod);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"rc = HttpMsg_setHost(msg_ptr, ");
                    String _upperCase_1 = RestClientGenerator.this._generatorUtils.getBaseName((Object)RestClientGenerator.this.setup).toUpperCase();
                    _builder.append((Object)_upperCase_1);
                    _builder.append((Object)"_HOST);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (rc != RC_OK)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return rc;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"const char* url_ptr = \"");
                    _builder.append((Object)url);
                    _builder.append((Object)"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"rc = HttpMsg_setReqUrl(msg_ptr, url_ptr);");
                    _builder.newLine();
                    _builder.append((Object)"if (rc != RC_OK)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return rc;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"HttpMsg_setContentType(msg_ptr, \"");
                    _builder.append(contentType);
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"rc = Msg_prependPartFactory(msg_ptr, &httpPayloadSerializer);");
                    _builder.newLine();
                    _builder.append((Object)"if (rc != RC_OK) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return rc;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"Callable_T sentCallable;");
                    _builder.newLine();
                    _builder.append((Object)"(void) Callable_assign(&sentCallable, httpClientOnSentCallback);");
                    _builder.newLine();
                    _builder.append((Object)"rc = HttpClient_pushRequest(msg_ptr, &sentCallable, &httpClientResponseCallback);");
                    _builder.newLine();
                    _builder.append((Object)"if (rc != RC_OK)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return rc;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"if(xSemaphoreTake(responseReceivedSemaphore, ");
                    String _upperCase_2 = RestClientGenerator.this._generatorUtils.getBaseName((Object)RestClientGenerator.this.setup).toUpperCase();
                    _builder.append((Object)_upperCase_2);
                    _builder.append((Object)"_TIMEOUT) == pdTRUE)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if(responseRetcode != RC_OK) {");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return EXCEPTION_HTTPREQUESTNOTOKEXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else if(responseStatusCode == Http_StatusCode_OK)");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return RC_OK;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"responseStatusCode");
                        }
                    };
                    CodeFragment _generateLogStatement = RestClientGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Warning, "HTTP response status code was %d", new CodeFragment[]{RestClientGenerator.this.codeFragmentProvider.create(_client)});
                    _builder.append((Object)_generateLogStatement, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"return EXCEPTION_HTTPREQUESTNOTOKEXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"} ");
                    _builder.newLine();
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    CodeFragment _generateLogStatement_1 = RestClientGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Warning, "HTTP request timed out", new CodeFragment[0]);
                    _builder.append((Object)_generateLogStatement_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return EXCEPTION_TIMEOUTEXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            _xblockexpression = this.codeFragmentProvider.create(_client).addHeader("BCDS_NetworkConfig.h", true, 750);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getHttpMethod(Expression expression) {
        String result = "Http_Method_Post";
        Enumerator _xifexpression = null;
        if (expression instanceof FeatureCall) {
            Enumerator _xblockexpression = null;
            EObject feature = ((FeatureCall)expression).getFeature();
            Enumerator _xifexpression_1 = null;
            if (feature instanceof Enumerator) {
                _xifexpression_1 = (Enumerator)feature;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            Enumerator _xifexpression_1 = null;
            if (expression instanceof ElementReferenceExpression) {
                Enumerator _xblockexpression_1 = null;
                EObject ref = ((ElementReferenceExpression)expression).getReference();
                Enumerator _xifexpression_2 = null;
                if (ref instanceof Enumerator) {
                    _xifexpression_2 = (Enumerator)ref;
                }
                _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        Enumerator enumerator = _xifexpression;
        if (enumerator != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Http_Method_");
            String _firstUpper = StringExtensions.toFirstUpper((String)enumerator.getName().toLowerCase());
            _builder.append(_firstUpper);
            result = _builder.toString();
        }
        return result;
    }

    public CodeFragment generateSignalInstanceGetter(SignalInstance signalInstance, String resultName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_FAILURE);");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true);
    }

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                CodeFragment _generateSetup = RestClientGenerator.this.servalpalGenerator.generateSetup(false);
                _builder.append((Object)_generateSetup);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"responseReceivedSemaphore = xSemaphoreCreateBinary();");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                CodeFragment _generateEnable = RestClientGenerator.this.servalpalGenerator.generateEnable();
                _builder.append((Object)_generateEnable);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"exception = HttpClient_initialize();");
                _builder.newLine();
                _builder.append((Object)"if(exception != RETCODE_OK) ");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 750).addHeader("Serval_HttpClient.h", true).addHeader("Serval_Network.h", true);
    }
}

