/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.extension;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mita.library.extension.Version;

public class LibraryExtensions {
    private static final String EXTENSION_POINT_ID = "org.eclipse.mita.library.extension.type_library";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_OPTIONAL = "optional";
    private static final String ATTRIBUTE_MODULE = "module";
    private static final String ELEMENT_RESOURCE_URI = "ResourceURI";
    private static final String ELEMENT_DEPENDENCY = "Dependency";
    private static final String ATTRIBUTE_URI = "uri";
    private static List<LibraryDescriptor> descriptors;

    public static List<LibraryDescriptor> getDescriptors() {
        if (descriptors == null) {
            descriptors = Lists.newArrayList();
            if (Platform.isRunning()) {
                LibraryExtensions.initFromExtensions();
            }
        }
        return descriptors;
    }

    public static List<LibraryDescriptor> getAvailablePlatforms() {
        ArrayList result = Lists.newArrayList();
        for (LibraryDescriptor libraryDescriptor : LibraryExtensions.getDescriptors()) {
            if (!libraryDescriptor.isOptional()) continue;
            result.add(libraryDescriptor);
        }
        return result;
    }

    public static List<LibraryDescriptor> getDefaultLibraries() {
        HashMap result = Maps.newHashMap();
        List<LibraryDescriptor> allDescriptors = LibraryExtensions.getDescriptors();
        for (LibraryDescriptor libraryDescriptor : allDescriptors) {
            if (libraryDescriptor.isOptional()) continue;
            if (result.containsKey(libraryDescriptor.getId())) {
                LibraryDescriptor currentDescriptor = (LibraryDescriptor)result.get(libraryDescriptor.getId());
                if (currentDescriptor.getVersion().compareTo(libraryDescriptor.getVersion()) >= 0) continue;
                result.put(libraryDescriptor.getId(), libraryDescriptor);
                continue;
            }
            result.put(libraryDescriptor.getId(), libraryDescriptor);
        }
        return Lists.newArrayList(result.values());
    }

    public static Iterable<LibraryDescriptor> getDescriptors(final String id) {
        return Iterables.filter(LibraryExtensions.getDescriptors(), (Predicate)new Predicate<LibraryDescriptor>(){

            public boolean apply(LibraryDescriptor input) {
                return id.equals(input.getId());
            }
        });
    }

    public static LibraryDescriptor getDescriptor(final String id, final Version version) {
        try {
            return (LibraryDescriptor)Iterables.find(LibraryExtensions.getDescriptors(), (Predicate)new Predicate<LibraryDescriptor>(){

                public boolean apply(LibraryDescriptor input) {
                    return id.equals(input.getId()) && input.getVersion().equals(version);
                }
            });
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public static Iterable<Version> getAvailableVersions(final String id) {
        Iterable allVersions = Iterables.transform((Iterable)Iterables.filter(LibraryExtensions.getDescriptors(), (Predicate)new Predicate<LibraryDescriptor>(){

            public boolean apply(LibraryDescriptor input) {
                return id.equals(input.getId());
            }
        }), (Function)new Function<LibraryDescriptor, Version>(){

            public Version apply(LibraryDescriptor input) {
                return input.getVersion();
            }
        });
        return Sets.newTreeSet((Iterable)allVersions);
    }

    protected static void initFromExtensions() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            descriptors.add(LibraryExtensions.createLibrary(element));
            ++n2;
        }
    }

    protected static LibraryDescriptor createLibrary(IConfigurationElement element) {
        String id = element.getAttribute(ATTRIBUTE_ID);
        String name = element.getAttribute(ATTRIBUTE_NAME);
        String description = element.getAttribute(ATTRIBUTE_DESCRIPTION);
        Version version = Version.fromString(element.getAttribute(ATTRIBUTE_VERSION));
        boolean optional = Boolean.valueOf(element.getAttribute(ATTRIBUTE_OPTIONAL));
        IConfigurationElement[] children = element.getChildren(ELEMENT_RESOURCE_URI);
        ArrayList resourceURIs = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement resourceURI = iConfigurationElementArray[n2];
            resourceURIs.add(URI.createURI((String)resourceURI.getAttribute(ATTRIBUTE_URI)));
            ++n2;
        }
        IConfigurationElement[] dependencyElements = element.getChildren(ELEMENT_DEPENDENCY);
        ArrayList dependencies = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray2 = dependencyElements;
        int n3 = dependencyElements.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement currentDependency = iConfigurationElementArray2[n4];
            dependencies.add(currentDependency.getAttribute(ATTRIBUTE_ID));
            ++n4;
        }
        return new LibraryDescriptor(id, name, description, version, resourceURIs, optional);
    }

    public static LibraryDescriptor getContainingLibrary(URI uri) {
        List<LibraryDescriptor> descriptors2 = LibraryExtensions.getDescriptors();
        for (LibraryDescriptor libraryDescriptor : descriptors2) {
            if (!libraryDescriptor.getResourceUris().contains(uri)) continue;
            return libraryDescriptor;
        }
        return null;
    }

    public static class LibraryDescriptor {
        private String id;
        private String name;
        private String description;
        private Version version;
        private List<URI> resourceUris;
        private boolean optional;
        private List<String> dependencies;
        private Module module;

        public LibraryDescriptor(String id, String name, String description, Version version, List<URI> resourceUris, boolean optional) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.version = version;
            this.resourceUris = resourceUris;
            this.optional = optional;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Version getVersion() {
            return this.version;
        }

        public List<URI> getResourceUris() {
            return this.resourceUris;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LibraryDescriptor other = (LibraryDescriptor)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public Module getModule() {
            return this.module;
        }
    }
}

