/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.inferrer;

import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;

public class OptionalTypeExtensions {
    public static final String OPTIONAL_TYPE_NAME = "optional";

    public TypeSpecifier getOptionalBaseType(TypeSpecifier result) {
        if (this.isOptional(result.getType()) && !result.getTypeArguments().isEmpty()) {
            return this.getOptionalBaseType((TypeSpecifier)result.getTypeArguments().get(0));
        }
        return result;
    }

    public ITypeSystemInferrer.InferenceResult getOptionalBaseType(ITypeSystemInferrer.InferenceResult result) {
        if (this.isOptional(result.getType()) && !result.getBindings().isEmpty()) {
            return this.getOptionalBaseType((ITypeSystemInferrer.InferenceResult)result.getBindings().get(0));
        }
        return result;
    }

    public boolean isOptional(Type type) {
        if (type != null) {
            return OPTIONAL_TYPE_NAME.equals(type.getName());
        }
        return false;
    }
}

