/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types.inferrer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;

public interface ITypeSystemInferrer {
    public static final String EXCEPTION_CODE = "RuntimeException";
    public static final String NO_INFER_METHOD_CODE = "NoInferMethod";
    public static final String IS_TYPE_CODE = "NotExpectedType.";
    public static final String NOT_TYPE_CODE = "NotType";
    public static final String NOT_SAME_CODE = "NotSame";
    public static final String NOT_COMPATIBLE_CODE = "IncompatibleTypes";
    public static final String NOT_INFERRABLE_TYPE_PARAMETER_CODE = "NotInferrableTypeParameter";

    public InferenceResult infer(EObject var1, IValidationIssueAcceptor var2);

    public InferenceResult infer(EObject var1);

    public static class InferenceResult {
        private Type type;
        private List<InferenceResult> bindings = new ArrayList<InferenceResult>();

        protected InferenceResult(Type type) {
            Assert.isNotNull((Object)type);
            this.type = type;
        }

        protected InferenceResult(Type type, List<InferenceResult> bindings) {
            Assert.isNotNull((Object)type);
            Assert.isNotNull(bindings);
            this.type = type;
            this.bindings.addAll(bindings);
        }

        public static InferenceResult from(Type type) {
            return new InferenceResult(type);
        }

        public static InferenceResult from(Type type, List<InferenceResult> bindings) {
            return new InferenceResult(type, bindings);
        }

        public Type getType() {
            return this.type;
        }

        public List<InferenceResult> getBindings() {
            return this.bindings;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.type.toString());
            if (this.bindings.size() > 0) {
                builder.append("<");
                String sep = "";
                for (InferenceResult type : this.bindings) {
                    builder.append(sep);
                    builder.append(type.toString());
                    sep = ",";
                }
                builder.append(">");
            }
            return builder.toString();
        }
    }

    public static class NullImpl
    implements ITypeSystemInferrer {
        @Override
        public InferenceResult infer(EObject object, IValidationIssueAcceptor acceptor) {
            return null;
        }

        @Override
        public InferenceResult infer(EObject object) {
            return null;
        }
    }
}

