/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions.inferrer;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.BitwiseAndExpression;
import org.eclipse.mita.base.expressions.BitwiseOrExpression;
import org.eclipse.mita.base.expressions.BitwiseXorExpression;
import org.eclipse.mita.base.expressions.BoolLiteral;
import org.eclipse.mita.base.expressions.ConditionalExpression;
import org.eclipse.mita.base.expressions.DoubleLiteral;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.FloatLiteral;
import org.eclipse.mita.base.expressions.HexLiteral;
import org.eclipse.mita.base.expressions.IntLiteral;
import org.eclipse.mita.base.expressions.LogicalAndExpression;
import org.eclipse.mita.base.expressions.LogicalNotExpression;
import org.eclipse.mita.base.expressions.LogicalOrExpression;
import org.eclipse.mita.base.expressions.LogicalRelationExpression;
import org.eclipse.mita.base.expressions.NullLiteral;
import org.eclipse.mita.base.expressions.NumericalAddSubtractExpression;
import org.eclipse.mita.base.expressions.NumericalMultiplyDivideExpression;
import org.eclipse.mita.base.expressions.NumericalUnaryExpression;
import org.eclipse.mita.base.expressions.ParenthesizedExpression;
import org.eclipse.mita.base.expressions.PostFixUnaryExpression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.expressions.ShiftExpression;
import org.eclipse.mita.base.expressions.StringLiteral;
import org.eclipse.mita.base.expressions.TypeCastExpression;
import org.eclipse.mita.base.expressions.UnaryOperator;
import org.eclipse.mita.base.expressions.inferrer.ExpressionsTypeInferrerMessages;
import org.eclipse.mita.base.expressions.inferrer.TypeParameterInferrer;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.GenericElement;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeAlias;
import org.eclipse.mita.base.types.TypeParameter;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.AbstractTypeSystemInferrer;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.xtext.EcoreUtil2;

public class ExpressionsTypeInferrer
extends AbstractTypeSystemInferrer
implements ExpressionsTypeInferrerMessages {
    @Inject
    protected TypeParameterInferrer typeParameterInferrer;

    public ITypeSystemInferrer.InferenceResult doInfer(AssignmentExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getVarRef());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getExpression());
        this.assertAssignable(result1, result2, String.format("Assignment operator '%s' may only be applied on compatible types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.inferTypeDispatch(e.getVarRef());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ConditionalExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getTrueCase());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getFalseCase());
        this.assertCompatible(result1, result2, String.format("Could not determine a common type for %s and %s.", result1, result2));
        this.assertIsSubType(this.inferTypeDispatch(e.getCondition()), this.getResultFor("boolean"), "conditional expression must be of type boolean.");
        return this.getCommonType(result1, result2);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalOrExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "||", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "||", result1, result2));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalAndExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "&&", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "&&", result1, result2));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalNotExpression e) {
        ITypeSystemInferrer.InferenceResult type = this.inferTypeDispatch(e.getOperand());
        this.assertIsSubType(type, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s.", "!", type));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BitwiseXorExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "^", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "^", result1, result2));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BitwiseOrExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "|", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "|", result1, result2));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BitwiseAndExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "&", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "&", result1, result2));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ShiftExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalRelationExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertCompatible(result1, result2, String.format("Comparison operator '%s' may only be applied on compatible types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        ITypeSystemInferrer.InferenceResult result = this.getResultFor("boolean");
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NumericalAddSubtractExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertCompatible(result1, result2, String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        this.assertIsSubType(result1, this.getResultFor("real"), String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getCommonType(this.inferTypeDispatch(e.getLeftOperand()), this.inferTypeDispatch(e.getRightOperand()));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NumericalMultiplyDivideExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getRightOperand());
        this.assertCompatible(result1, result2, String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        this.assertIsSubType(result1, this.getResultFor("real"), String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getCommonType(result1, result2);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NumericalUnaryExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getOperand());
        if (e.getOperator() == UnaryOperator.COMPLEMENT) {
            this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s.", Character.valueOf('~'), result1));
        } else {
            this.assertIsSubType(result1, this.getResultFor("real"), String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s.", new Object[]{e.getOperator(), result1}));
        }
        return result1;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(PostFixUnaryExpression e) {
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch(e.getOperand());
        this.assertIsSubType(result, this.getResultFor("real"), String.format("Postfix operator '%s' may only be applied on numeric types, not on %s.", new Object[]{e.getOperator(), result}));
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TypeCastExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch(e.getOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch(e.getType());
        this.assertCompatible(result1, result2, String.format("Cannot cast from %s to %s.", result1, result2));
        return this.inferTypeDispatch(e.getType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(EnumerationType enumType) {
        return ITypeSystemInferrer.InferenceResult.from(enumType);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Enumerator enumerator) {
        return ITypeSystemInferrer.InferenceResult.from((Type)EcoreUtil2.getContainerOfType((EObject)enumerator, Type.class));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Type type) {
        return ITypeSystemInferrer.InferenceResult.from(type.getOriginType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TypeAlias typeAlias) {
        return this.inferTypeDispatch(typeAlias.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FeatureCall e) {
        HashMap inferredTypeParameterTypes = Maps.newHashMap();
        this.typeParameterInferrer.inferTypeParametersFromOwner(this.inferTypeDispatch(e.getOwner()), inferredTypeParameterTypes);
        if (e.isOperationCall()) {
            if (!e.getFeature().eIsProxy()) {
                return this.inferOperation(e, (Operation)e.getFeature(), inferredTypeParameterTypes);
            }
            return this.getAnyType();
        }
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch(e.getFeature());
        if (result != null) {
            result = this.typeParameterInferrer.buildInferenceResult(result, inferredTypeParameterTypes, this.acceptor);
        }
        if (result == null) {
            return this.getAnyType();
        }
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ElementReferenceExpression e) {
        if (e.isOperationCall()) {
            if (e.getReference() != null && !e.getReference().eIsProxy()) {
                if (e.getReference() instanceof Operation) {
                    return this.inferOperation(e, (Operation)e.getReference(), Maps.newHashMap());
                }
                return this.inferTypeDispatch(e.getReference());
            }
            return this.getAnyType();
        }
        return this.inferTypeDispatch(e.getReference());
    }

    protected ITypeSystemInferrer.InferenceResult inferOperation(ArgumentExpression e, Operation op, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping) {
        List<ITypeSystemInferrer.InferenceResult> argumentTypes = this.getArgumentTypes(this.getOperationArguments(e));
        EList<Parameter> parameters = op.getParameters();
        ArrayList<ITypeSystemInferrer.InferenceResult> argumentsToInfer = new ArrayList<ITypeSystemInferrer.InferenceResult>();
        ArrayList<Parameter> parametersToInfer = new ArrayList<Parameter>();
        int i = 0;
        while (i < parameters.size()) {
            if (!typeParameterMapping.containsKey(((Parameter)parameters.get(i)).getType())) {
                parametersToInfer.add((Parameter)parameters.get(i));
                if (i < argumentTypes.size()) {
                    argumentsToInfer.add(argumentTypes.get(i));
                }
            }
            ++i;
        }
        this.typeParameterInferrer.inferTypeParametersFromOperationArguments(parametersToInfer, argumentsToInfer, typeParameterMapping, this.acceptor);
        this.validateParameters(typeParameterMapping, op, this.getOperationArguments(e), this.acceptor);
        return this.inferReturnType(op, typeParameterMapping);
    }

    protected List<Expression> getOperationArguments(ArgumentExpression e) {
        return e.getExpressions();
    }

    protected List<ITypeSystemInferrer.InferenceResult> getArgumentTypes(List<Expression> args) {
        ArrayList<ITypeSystemInferrer.InferenceResult> argumentTypes = new ArrayList<ITypeSystemInferrer.InferenceResult>();
        for (Expression arg : args) {
            argumentTypes.add(this.inferTypeDispatch(arg));
        }
        return argumentTypes;
    }

    protected ITypeSystemInferrer.InferenceResult inferReturnType(Operation operation, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        ITypeSystemInferrer.InferenceResult returnType = this.inferTypeDispatch(operation);
        if ((returnType = this.typeParameterInferrer.buildInferenceResult(returnType, inferredTypeParameterTypes, this.acceptor)) == null) {
            return this.getAnyType();
        }
        return returnType;
    }

    private ITypeSystemInferrer.InferenceResult getAnyType() {
        return ITypeSystemInferrer.InferenceResult.from(this.registry.getType("any"));
    }

    public Map<TypeParameter, ITypeSystemInferrer.InferenceResult> validateParameters(Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping, Operation operation, List<Expression> args, IValidationIssueAcceptor acceptor) {
        EList<Parameter> parameters = operation.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            if (args.size() > i) {
                Parameter parameter = (Parameter)parameters.get(i);
                Expression argument = args.get(i);
                ITypeSystemInferrer.InferenceResult parameterType = this.inferTypeDispatch(parameter);
                ITypeSystemInferrer.InferenceResult argumentType = this.inferTypeDispatch(argument);
                parameterType = this.typeParameterInferrer.buildInferenceResult(parameterType, typeParameterMapping, acceptor);
                this.assertAssignable(parameterType, argumentType, String.format("Incompatible types %s and %s.", argumentType, parameterType));
            }
            ++i;
        }
        return typeParameterMapping;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ParenthesizedExpression e) {
        return this.inferTypeDispatch(e.getExpression());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(PrimitiveValueExpression e) {
        return this.inferTypeDispatch(e.getValue());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BoolLiteral literal) {
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(IntLiteral literal) {
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(HexLiteral literal) {
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(DoubleLiteral literal) {
        return this.getResultFor("real");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FloatLiteral literal) {
        return this.getResultFor("real");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(StringLiteral literal) {
        return this.getResultFor("string");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NullLiteral literal) {
        return this.getResultFor("null");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Property p) {
        ITypeSystemInferrer.InferenceResult type = this.inferTypeDispatch(p.getTypeSpecifier());
        return type;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Operation e) {
        return e.getTypeSpecifier() == null ? this.getResultFor("void") : this.inferTypeDispatch(e.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Parameter e) {
        return this.inferTypeDispatch(e.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TypeSpecifier specifier) {
        if (specifier.getType() instanceof GenericElement && ((GenericElement)((Object)specifier.getType())).getTypeParameters().size() > 0) {
            ArrayList<ITypeSystemInferrer.InferenceResult> bindings = new ArrayList<ITypeSystemInferrer.InferenceResult>();
            EList<TypeSpecifier> arguments = specifier.getTypeArguments();
            for (TypeSpecifier typeSpecifier : arguments) {
                ITypeSystemInferrer.InferenceResult binding = this.inferTypeDispatch(typeSpecifier);
                if (binding == null) continue;
                bindings.add(binding);
            }
            Type type = this.inferTypeDispatch(specifier.getType()).getType();
            return ITypeSystemInferrer.InferenceResult.from(type, bindings);
        }
        return this.inferTypeDispatch(specifier.getType());
    }
}

