/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ShiftOperator implements Enumerator
{
    LEFT(0, "left", "<<"),
    RIGHT(1, "right", ">>");

    public static final int LEFT_VALUE = 0;
    public static final int RIGHT_VALUE = 1;
    private static final ShiftOperator[] VALUES_ARRAY;
    public static final List<ShiftOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ShiftOperator[]{LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ShiftOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShiftOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShiftOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShiftOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShiftOperator get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return RIGHT;
            }
        }
        return null;
    }

    private ShiftOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

