/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.mat.collect.HashMapIntObject;

public abstract class ObjectCache<E> {
    private int maxSize;
    private final HashMapIntObject<Entry<E>> map;
    private final List<LinkedList<Entry<E>>> lfus;
    private int maxLfuBuckets = 0;
    private int lowestNonEmptyLfu = 0;

    public ObjectCache(int maxSize) {
        this.maxSize = maxSize;
        this.map = new HashMapIntObject(maxSize);
        this.lfus = new ArrayList<LinkedList<Entry<E>>>(5);
        this.maxLfuBuckets = maxSize / 3;
    }

    public synchronized E get(int objectId) {
        Entry e = (Entry)this.map.get(objectId);
        if (e != null) {
            this.revalueEntry(e);
        } else {
            e = new Entry();
            e.object = this.load(objectId);
            e.key = objectId;
            this.doInsert(e);
            while (this.map.size() > this.maxSize) {
                this.removeLeastValuableNode();
            }
        }
        return e.object;
    }

    public synchronized void clear() {
        this.map.clear();
        this.lfus.clear();
    }

    protected abstract E load(int var1);

    protected synchronized void doInsert(Entry<E> e) {
        this.lfu(e.numUsages).addFirst(e);
        Entry p = (Entry)this.map.put(e.key, e);
        this.lowestNonEmptyLfu = 0;
        if (p != null) {
            this.lfu(p.numUsages).remove(p);
        }
    }

    protected final LinkedList<Entry<E>> lfu(int numUsageIndex) {
        int lfuIndex = Math.min(this.maxLfuBuckets, numUsageIndex);
        if (lfuIndex >= this.lfus.size()) {
            LinkedList<Entry<E>> lfu = new LinkedList<Entry<E>>();
            this.lfus.add(lfuIndex, lfu);
            return lfu;
        }
        return this.lfus.get(lfuIndex);
    }

    protected void revalueEntry(Entry<E> entry) {
        LinkedList<Entry<E>> currBucket = this.lfu(entry.numUsages);
        LinkedList<Entry<Entry<E>>> nextBucket = this.lfu(++entry.numUsages);
        currBucket.remove(entry);
        nextBucket.addFirst(entry);
    }

    protected LinkedList<Entry<E>> getLowestNonEmptyLfu() {
        LinkedList<Entry<E>> lfu = null;
        int i = this.lowestNonEmptyLfu;
        while (i < this.lfus.size()) {
            lfu = this.lfu(i);
            if (lfu.size() != 0) {
                this.lowestNonEmptyLfu = i;
                return lfu;
            }
            ++i;
        }
        return lfu;
    }

    protected void removeLeastValuableNode() {
        LinkedList<Entry<E>> lfu = this.getLowestNonEmptyLfu();
        Entry<E> lln = lfu.remove(lfu.size() - 1);
        this.map.remove(lln.key);
    }

    static class Entry<E> {
        E object;
        int key;
        int numUsages;

        Entry() {
        }
    }
}

