/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;

class ArrayIndexExpression
extends Expression {
    List<Expression> parameters;

    public ArrayIndexExpression(List<Expression> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        Object subject = ctx.getSubject();
        if (subject == null) {
            return null;
        }
        Object[] arguments = new Object[this.parameters.size()];
        int ii = 0;
        while (ii < arguments.length) {
            arguments[ii] = this.parameters.get(ii).compute(ctx);
            ++ii;
        }
        Object indexObj = arguments[0];
        int index = this.evalIndex(indexObj);
        boolean range = arguments.length > 1;
        int index2 = index;
        if (range) {
            index2 = this.evalIndex(arguments[1]);
        }
        if (subject.getClass().isArray()) {
            int len = Array.getLength(subject);
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return new ArraySubList(subject, i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return Array.get(subject, index);
        }
        if (subject instanceof List) {
            List l = (List)subject;
            int len = l.size();
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return ((List)subject).subList(i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return ((List)subject).get(index);
        }
        if (subject instanceof IPrimitiveArray) {
            IPrimitiveArray array = (IPrimitiveArray)subject;
            int len = array.getLength();
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return new PrimitiveArraySubList(array, i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return array.getValueAt(index);
        }
        if (subject instanceof IObjectArray) {
            IObjectArray array = (IObjectArray)subject;
            int len = array.getLength();
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return new ObjectArraySubList(array, i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            long addr = array.getReferenceArray(index, 1)[0];
            if (addr == 0L) {
                return null;
            }
            ISnapshot snapshot = array.getSnapshot();
            ObjectReference or = new ObjectReference(snapshot, addr);
            return or.getObject();
        }
        if (subject instanceof IObject) {
            ExtractedCollection coll;
            IObject obj = (IObject)subject;
            ExtractedMap map = CollectionExtractionUtils.extractMap((IObject)obj);
            if (map != null) {
                if (!map.hasExtractableContents() || !map.hasSize()) {
                    return null;
                }
                Integer objlen = map.size();
                if (objlen != null) {
                    int len = objlen;
                    if (range) {
                        int i1 = this.normalize(index, len, 0);
                        int i2 = this.normalize(index2, len, 1);
                        return new MapObjectSubList(map, i1, i2);
                    }
                    if (index >= len) {
                        return null;
                    }
                    if (index < 0) {
                        return null;
                    }
                    return new MapObjectSubList(map, index, index + 1).get(0);
                }
            }
            if ((coll = CollectionExtractionUtils.extractList((IObject)obj)) != null) {
                if (!coll.hasExtractableContents() || !coll.hasSize()) {
                    return null;
                }
                Integer objlen = coll.size();
                if (objlen != null) {
                    int len = objlen;
                    if (range) {
                        int i1 = this.normalize(index, len, 0);
                        int i2 = this.normalize(index2, len, 1);
                        return new CollectionObjectSubList(coll, i1, i2);
                    }
                    if (index >= len) {
                        return null;
                    }
                    if (index < 0) {
                        return null;
                    }
                    ISnapshot snapshot = coll.getSnapshot();
                    int objectId = coll.extractEntryIds()[index];
                    coll.getSnapshot().getObject(objectId);
                    return snapshot.getObject(objectId);
                }
            }
        }
        throw new IllegalArgumentException(subject + this.toString() + ": " + subject.getClass());
    }

    private int evalIndex(Object indexObj) {
        if (!(indexObj instanceof Integer || indexObj instanceof Short || indexObj instanceof Byte)) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + ": " + (indexObj != null ? indexObj.getClass() : null));
        }
        int index = ((Number)indexObj).intValue();
        return index;
    }

    private int normalize(int i, int s, int a) {
        if (i < 0) {
            i += s;
        }
        if ((i += a) > s) {
            i = s;
        }
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        for (Expression element : this.parameters) {
            boolean isContextDependent = element.isContextDependent(ctx);
            if (!isContextDependent) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[");
        Iterator<Expression> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Expression element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(":");
        }
        buf.append("]");
        return buf.toString();
    }

    private static class ArraySubList
    extends AbstractList<Object> {
        private final Object subject;
        private final int i1;
        private final int i2;

        private ArraySubList(Object subject, int i1, int i2) {
            this.subject = subject;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return Array.get(this.subject, this.i1 + index);
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }

    private static class CollectionObjectSubList
    extends AbstractList<IObject> {
        private final ExtractedCollection coll;
        private final int i1;
        private final int i2;
        SoftReference<int[]> sr = null;

        public CollectionObjectSubList(ExtractedCollection coll, int i1, int i2) {
            this.coll = coll;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public IObject get(int index) {
            int[] objs;
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            if (this.sr == null || (objs = this.sr.get()) == null) {
                objs = this.coll.extractEntryIds();
                this.sr = new SoftReference<int[]>(objs);
            }
            if (this.i1 + index >= this.i2) {
                throw new IllegalArgumentException(String.valueOf(index) + " >= " + (this.i2 - this.i1) + " " + this.coll.getTechnicalName());
            }
            if (this.i1 + index >= objs.length) {
                return null;
            }
            int objectId = objs[this.i1 + index];
            try {
                return this.coll.getSnapshot().getObject(objectId);
            }
            catch (SnapshotException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }

    private static class MapObjectSubList
    extends AbstractList<Map.Entry<IObject, IObject>> {
        private final ExtractedMap coll;
        private final int i1;
        private final int i2;
        SoftReference<List<Map.Entry<IObject, IObject>>> sr = null;
        Iterator<Map.Entry<IObject, IObject>> it;

        public MapObjectSubList(ExtractedMap map, int i1, int i2) {
            this.coll = map;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Map.Entry<IObject, IObject> get(int index) {
            List<Object> objs;
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            if (this.sr == null || (objs = this.sr.get()) == null) {
                objs = new ArrayList();
                this.it = this.coll.iterator();
                this.sr = new SoftReference(objs);
            }
            if (this.i1 + index >= this.i2) {
                throw new IllegalArgumentException(String.valueOf(index) + " >= " + (this.i2 - this.i1) + " " + this.coll.getTechnicalName());
            }
            int i = objs.size();
            while (this.it.hasNext() && i < this.i1 + index + 1) {
                objs.add(this.it.next());
                ++i;
            }
            if (this.i1 + index >= objs.size()) {
                return null;
            }
            return (Map.Entry)objs.get(this.i1 + index);
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }

    private static class ObjectArraySubList
    extends AbstractList<IObject> {
        private final IObjectArray array;
        private final int i1;
        private final int i2;

        public ObjectArraySubList(IObjectArray array, int i1, int i2) {
            this.array = array;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public IObject get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            long addr = this.array.getReferenceArray(this.i1 + index, 1)[0];
            if (addr == 0L) {
                return null;
            }
            ISnapshot snapshot = this.array.getSnapshot();
            try {
                ObjectReference or = new ObjectReference(snapshot, addr);
                return or.getObject();
            }
            catch (SnapshotException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }

    private static class PrimitiveArraySubList
    extends AbstractList<Object> {
        private final IPrimitiveArray array;
        private final int i1;
        private final int i2;

        private PrimitiveArraySubList(IPrimitiveArray array, int i1, int i2) {
            this.array = array;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return this.array.getValueAt(this.i1 + index);
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }
}

